//
//  AppServices.h
//  SLOSYN
//
//  Créé par Miguel Saro le 02/04/12.
//  Tout droits réservés, __La Torréfaction Joyeuse__, 2012.  
//

#import <Cocoa/Cocoa.h>
#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import "Definir.h"
   
//#define is_plainFile 1
#define is_plainFile kLSItemInfoIsPlainFile
#define is_package kLSItemInfoIsPackage
#define is_application kLSItemInfoIsApplication
#define is_container kLSItemInfoIsContainer
#define is_alias kLSItemInfoIsAliasFile
#define is_symblink kLSItemInfoIsSymlink
#define is_invisible kLSItemInfoIsInvisible
#define is_hardlink 128
#define is_volume kLSItemInfoIsVolume

#define is_erreur 2048
#define is_liens is_alias+is_hardlink+is_symblink
#define is_filtre is_plainFile+is_package+is_application+is_container+is_alias+is_invisible+is_volume


// NSApplication
// =============

@interface NSApplication (AppServices)

- (BOOL)estDossier:(NSString *)leChemin ;													// c'est un dossier ?
- (NSString *)localpath:(NSString *)celuila ;												// chemin localisé
- (NSString *)pathUser:(NSString *)celuici ;												// chemin localisé avec tilde
- (NSString *)localpath:(NSString *)cuila :(NSFileManager *)gerer ;
- (NSString *)lURL:(NSString *)CeChemin ;													// Url d'un chemin
- (void)auFeu:(NSString *)erreur defBouton:(NSString *)label ;								// message d'erreur
- (void)auFeu:(NSString *)erreur defBouton:(NSString *)label icon:(NSImage *)licone ;		// message d'erreur avec icone spécifique
- (void)auFeu:(NSString *)titre  bouton:(NSString *)label icon:(NSImage *)licone ;			// message d'erreur avec icone spécifique
- (void)auFeu:(NSString *)lerreur titre:(NSString *)titre defBouton:(NSString *)label0 bouton1:(NSString *)label1 bouton2:(NSString *)label2 icon:(NSImage *)licone ;
- (int)InfoFichier:(NSString *)lechemin :(NSString *)leNom :(char *)leType ;				// prise infos du fichier

- (NSFileHandle *)handleInit:(NSString *)chemin ;											// crée fichier, retourne handle
- (BOOL)ecritUtf16:(NSString *)chemin letexte:(NSString *)letexte ;							// sauve texte dans un fichier UTF16
- (BOOL)ecritUtf8:(NSString *)chemin letexte:(NSString *)letexte ;							// sauve texte dans un fichier UTF8

- (void)stringTexte:(NSString *)leString letexte:(NSMutableData *)letexte leFlag:(BOOL)leFlag comment:(NSString *)comment ;	// string-> data
- (void)stringTexte:(NSString *)xString letexte:(NSMutableData *)xtexte leFlag:(BOOL)xFlag ;
- (void)stringTexte:(NSString *)xString letexte:(NSMutableData *)xtexte ;

- (int)relationChemin1:(NSString *)chemin1 chemin2:(NSString *)chemin2 ;					// relation entre deux chemins


@end
