/*
 *  Definir.h
 *  SLOSYN
 *
 *  Créé par Miguel Saro le 02/04/12.
 *  Tout droits réservés, - Cocoa Pod -, 2012.
 *
 */


#define preferencesVersion @"1.4"
#import "version.h"
#define xbrt @"srt"

#define localiser(A)  [[NSBundle mainBundle] localizedStringForKey:A value:A table:@"Localisable"]
#define machine(A)  [[NSBundle mainBundle] localizedStringForKey:A value:A table:@"device"]


typedef unsigned int  sloSyn_error ;

enum sloSyn_err
  {
    sloSyn_SUCCESS = 0,
    
    sloSyn_ERR_ALREADY_INIT,
    sloSyn_ERR_LIBUSB,
    sloSyn_ERR_NOT_INIT,
    sloSyn_ERR_NOT_FOUND,
    sloSyn_ERR_MEMORY,
    sloSyn_ERR_TIMEOUT,
    sloSyn_ERR_IO,
	sloSyn_ERR_finBande,

    sloSyn_ERR_MAX
  } ;
  
enum typcar
  { 
	car_Cont = 0,	// continue sans ranger.
	Kar_Cont,		// Range et continue
	car_Bloc,		// fin de bloc sans Ranger
	Kar_Bloc,		// Range, fin de bloc
	car_fini,		// fin de ruban, texte, fichier ...., sans Ranger?
	Kar_fini		// Range, et autre fin
  };



#ifdef simule

#define leRuban  @"\nIl pleut\n\
C'est pas ma faute à moi\n\
Les carreaux de l'usine\n\
Sont toujours mal lavés\n\
Il pleut\n\
Les carreaux de l'usine\n\
Y'en a beaucoup de cassés\n\
à è ì ò ù À È Ì Ò Ù á é í ó ú Á É Í Ó Ú\n\
â ê î ô û Â Ê Î Ô Û ä ë ï ö ü Ä Ë Ï Ö Ü\n"


//#define BS @"àèìòùÀÈÌÒÙáéíóúÁÉÍÓÚâêîôûÂÊÎÔÛäëïöüÄËÏÖÜ"

#endif

#define accents @"'`^\"´"

enum Kspec {
ZUT = 0,			/* NULL		*/
SOH = 1,			/* SOH		(Start of Header) */
STX = 2,			/* STX		(Start of Text) */
ETX = 3,			/* ETX		(End of Text) */
EOT = 4,			/* EOT		(End of Transmission) */
ENQ = 5,			/* ENQ		(Enquiry) */
ACK = 6,			/* ACK		(Acknowledgment) */
BEL = 7,			/* BEL    	(Bell) */
 BS = 8,			/*  BS    	(Backspace) diacritiques ?*/
 HT = 9,			/*  HT    	(Horizontal Tab) */
 LF = 10,			/*  LF    	(Line Feed) */
 VT = 11,			/*  VT    	(Vertical Tab) */
 FF = 12,			/*  FF    	(Form Feed) */
 CR = 13,			/*  CR    	(Carriage Return) */
 SO = 14,			/*  SO    	(Shift Out) */
 SI = 15,			/*  SI    	(Shift In) */
DLE = 16,			/* DLE    	(Data Link Escape) */
DC1 = 17,			/* DC1    	(XON)(Device Control 1) */
DC2 = 18,			/* DC2    	(Device Control 2) */
DC3 = 19,			/* DC3    	(XOFF)(Device Control 3) */
DC4 = 20,			/* DC4    	(Device Control 4) */
NAK = 21,			/* NAK    	(Negative Acknowledgement) */
SYN = 22,			/* SYN    	(Synchronous Idle) */
ETB = 23,			/* ETB    	(End of Trans. Block) */
CAN = 24,			/* CAN    	(Cancel) */
 EM = 25,			/*  EM    	(End of Medium) */
SUB = 26,			/* SUB    	(Substitute) */
ESC = 27,			/* ESC    	(Escape) */
 FS = 28,			/*  FS    	(File Separator) */
 GS = 29,			/*  GS    	(Group Separator) */
 RS = 30,			/*  RS    	(Request to Send)(Record Separator) */
 US = 31,			/*  US    	(Unit Separator) */
DEL = 127			/* DEL		à ignorer*/
} ;



typedef struct 
{
unsigned bCR:1 ;	// CR
unsigned bLF:1 ;	// LF
unsigned bETX:1 ;	// end of text
unsigned bEOT:1 ;	// end of transmission
unsigned bETB:1 ;	// end of transmission block
unsigned bEM:1 ;	// end of medium
unsigned bFS:1 ;	// File separator
unsigned bGS:1 ;	// group separator
unsigned bRS:1 ;	// record separator
unsigned bUS:1 ;	// Unit separator
unsigned b00:1 ;	// 00 consécutifs
unsigned bff:1 ;	// ff consécutifs
unsigned bkr:1 ;	// caractères consécutifs
unsigned b78:1 ;	// supprime bit 8
unsigned vir:1 ;	// virgule fin de ligne
} reglages ;

//  format d'impression hexa
//	#define impHexa		@"/n %2x"

#define nbr_tr 3

typedef union 
{
	UInt64	tr[nbr_tr] ;
	UInt8	br[nbr_tr*sizeof(UInt64)] ;
} car16 ;

// Nbr ff atteint
#define cffs  1
// Nbr nuls atteint
#define cnls  2
// Nbr caractère spécifique atteint
#define ckrt  4
// stop utilisateur 
#define cstp  8

// définition du nom de la notification.
//
#define slosyn_notif @"slosyn_notif"

