//
//  slosynqe1.m
//  SLOSYN
//
//  Créé le 17/12/12 par Miguel Saro.
//  Tout droits réservés par - Cocoa Pod -, 2012.
//

#import "slosyn.h"
#import "slosyn_types.h"
#import "slosynqe1.h"
#import "slosynqe2.h"
#import "externe.h"


// lecture de la bande et controle des conditions d'arrêt.

@interface slosynqe1 (blind)

- (BOOL)lirePlus:(Byte *)bbf  ndx:(NSInteger)ndx ;

@end


@implementation slosynqe1


- (id)initialise:(UInt8 *)Karet ff:(NSInteger)ff nul:(NSInteger)nul sns:(NSInteger)sns binr:(BOOL)binr
								masq:(NSUInteger)masq operationClass:(Class)cc queue:(NSOperationQueue *)qq
{
NSInteger x ;

	self = [super init];
    if (![cc instancesRespondToSelector:@selector(initialise:buf:nbr:)])
	 {
		[self release];
		return nil;
     } ;
	krStop.br[0] = krStop.br[1] = 0 ;
	for (x=0 ; Karet[0]!=0 && x<20 ; x++)      // copie la liste des caractères d'arrêt
	 {	krStop.br[x] = Karet[x] ; krStop.br[x+1]=0 ; } ;
	lesFF = ff ;
	lesNul= nul ;
	leSens= sns ;
	binair = binr ;
	masque = (UInt8)masq ;
	queue = [qq retain];
	return self;
}


- (void)dealloc
{
    [queue release];
    [super dealloc];
}


// lecture de la bande 
//
- (void)main
{
NSAutoreleasePool	*pool ;
size_t	konte, x ;
uint8	npad ;										// nbr caractère à lire				
slosyn_error_t error;
slosyn_cmd_t cmd;

	pool = [[NSAutoreleasePool alloc] init];
	kff = knl = kkr = konte = 0 ;
	npad = binair ? 16 : 1 ;
	ici.tr[0] = ici.tr[1] = ici.tr[2] = 0 ; 						// vide buffer réception.
	
	do 
	 {	
		cmd.req.req = SLOSYN_REQ_READ;
		cmd.req.dir = (unsigned int)leSens ;
		cmd.req.nchars = npad ;

		error = send_recv_cmd_or_reopen(handle, &cmd);				// Lecture
		if (error != SLOSYN_ERROR_SUCCESS) 
		 {	slosynqe2 *slosynet = [[slosynqe2 alloc] initialise:-1 buf:&ici.br[0] 
									nbr: konte<(2 * sizeof(UInt64)) ? konte : (2 * sizeof(UInt64))] ;
			[slosynet setQueuePriority: 2.0] ;
			[queue addOperation: slosynet] ;
			[slosynet release] ;
		 } ;

		konte = npad<cmd.rep.nchars ? npad : cmd.rep.nchars ;		// nombre de caractères
		for (x=0 ; x<konte ; x++)
			ici.br[kkr++] = cmd.req.chars[x] ;
	  }
	while ([self lirePlus:&ici.br[0] ndx:kkr] && (error==SLOSYN_ERROR_SUCCESS)) ;	// lire caractère suivant ?
	
	beurk = error ;													// fin de lecture

	[pool release];
}

// vérifie les conditions d'arrêt de la lecture
//
- (BOOL)lirePlus:(UInt8 *)bbf  ndx:(NSInteger)ndx
{
NSInteger x, y, z, funct = 0 ;		// le code de l'arret.
UInt8  bbk ;

	z = funct = 0 ;
	if (!binair)
		z= ndx-1 ;
	
	for (x=z ; x<ndx ; x++)
	 {	bbk = bbf[x] & masque ;
		if ((lesFF > 0) && (bbk == (0xff & masque)))
		 {	kff++ ; if (kff >= lesFF) funct |= cffs ; }				// nbr de ff consécutifs atteint
		else 
			kff = 0 ;
		if ((lesNul > 0) && (bbk == 0x00))
		 {	knl++ ; if (knl >=lesNul) funct |= cnls ; }				// nbr de 00 consécutifs atteint
		else 
			knl = 0 ;
		if (!binair)
		{	for (y=0 ; (krStop.br[y] != 0) && (y<20) ; y++ )
				if (krStop.br[y] == bbk)							// trouvé caractère d'arrêt spécifique ?
 				 {	funct |= ckrt ; break ; } ;
		} ;
	 } ;	

	 
	if (stop) funct |= cstp ;										// stop utilisateur. ?
	
	if ((funct > 0) || (ndx >= (2 * sizeof(UInt64))))				// conditions d'arrêt ou 16 caractères lus.
	 {																// envoie les données
		slosynqe2 *slosynet = [[slosynqe2 alloc] initialise:funct  buf:&ici.br[0] 
								 nbr: ndx<(2 * sizeof(UInt64)) ? ndx : (2 * sizeof(UInt64))] ;
		[slosynet setQueuePriority: 2.0] ;
		[queue addOperation: slosynet] ;
		[slosynet release] ;
		kkr = 0 ; ici.tr[0] = ici.tr[1] = ici.tr[2] = 0 ;
	 } ;
	return (funct == 0) ;
}

@end
