//
//  SloSyn_106AppDelegate.m
//  SloSyn_106
//
//  Créé le 05/01/13 par Miguel Saro.
//  Tout droits réservés, - Cocoa Pod -, 2013.
//

#import "AppDelegate.h"
#import "AuFond.h"
#import "Console.h"
#import "Pref.h"
#import "slosynqe1.h"
#import "slosynqe2.h"
#import "slosyn_types.h"
#import "slosyn.h"


slosyn_handle_t *handle ;							// structure de gestion
slosyn_error_t  beurk ;								// erreur USB, Lecture ....
BOOL stop ;											// arrêt lecture si YES

extern u_int16_t  vendrID ;
extern u_int16_t  lectrID ;


@interface AppDelegate (etendu)

- (void)devalide:(BOOL)valide ;
- (void)terminer ;
- (void)lecture ;
- (void)testPresent:(NSTimer*)theTimer ;
- (BOOL)show_alarms:(sloSyn_error)bourf ;
- (BOOL)show_alarms:(sloSyn_error)burf stop:(BOOL)stpt ;
- (void)setTimer:(NSTimer *)value ;
- (void)blocRuban ;
- (void)laLecture:(BOOL)tester ;
- (UInt16)numIdentifie:(NSString *)vv ;

@end


@implementation AppDelegate

- (IBAction)a_test:(id)sender
{
	[self laLecture:YES] ;
}

- (IBAction)a_lire:(id)sender						// lire la bande
{
	[self laLecture:NO] ;
}

- (IBAction)a_aret:(id)sender 						// ici Arret opérations
{
	[queue cancelAllOperations] ;
	stop = YES ;
	[self devalide:YES] ;							// arret de la queue????
}

- (IBAction)a_prefr:(id)sender						// préférences pour
{													// l'arrêt automatique
	if ([o_Prefer isVisible])
		[o_Prefer orderOut:self] ;
	else 
		[o_Prefer orderFront:self] ;
}

- (IBAction)a_laide:(id)sender
{
NSString *l_aide ;

	l_aide = [[NSBundle mainBundle] pathForResource:@"index" ofType:@"html" inDirectory:@"laide"] ;
	
	if (![[NSWorkspace sharedWorkspace] openFile:l_aide withApplication:@"HelpViewer"])
		if (![[NSWorkspace sharedWorkspace] openFile:l_aide withApplication:@"Help Viewer"])
             [[NSWorkspace sharedWorkspace] openFile:l_aide] ;
}

- (IBAction)a_bloc:(id)sender						// choix arrêt par fin de bloc
{	[self blocRuban] ; }

- (IBAction)a_ruba:(id)sender						// sans arrêts par fin de bloc
{	[self blocRuban] ; }

// -------------------------------------------------------------------------

- (void)awakeFromNib
{
SInt32			osMajor ;
SInt32			osMinor ;
NSString		*versOS ;

	enCours = NO ;
	Gestalt(gestaltSystemVersionMajor, &osMajor) ;
	Gestalt(gestaltSystemVersionMinor, &osMinor) ;

	if (  (osMajor != OSxhmi) || ( (osMinor < OSxlmi) || (osMinor > OSxlma)) )	// limite OSX 10.6 à 10.9
	 {	versOS = [NSString stringWithFormat:localiser(@"cantRun"), OSxV] ;
		NSRunCriticalAlertPanel(versOS, localiser(@"upgradeMacOS"),@"Ok",nil,nil) ;
        [NSApp terminate:self];
	 } ;
	iNext = [NSImage imageNamed:@"next"] ; [iNext retain] ;
	iBack = [NSImage imageNamed:@"back"] ; [iBack retain] ;
	iCone = [NSImage imageNamed:@"trp125b.png"] ; [iCone retain] ;   // NSApplication
	
	brancher = [NSString stringWithString:localiser(@"lectoui")] ; [brancher retain] ;
	debrancher = [NSString stringWithString:localiser(@"lectnon")] ; [debrancher retain] ;
	[self metLeFond:o_fenetre] ;
	[o_theBox setContentView:o_vueStart] ;
	handle = NULL ;
	queue = [[NSOperationQueue alloc] init] ;
	[queue retain] ;
}

- (u_int16_t)numIdentifie:(NSString *)vv
{
char idnt[30] ;
UInt laisse ;

	[vv getCString:idnt maxLength:29 encoding:NSASCIIStringEncoding] ;
	sscanf(idnt, "%i", &laisse) ; 
	return (u_int16_t)laisse ;
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
	[self existePref] ;
	[o_consol consolInit] ;
	[self devalide:YES] ;
	
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(anyThread_handle:) name:slosyn_notif object:nil];

	vendrID = [self numIdentifie:machine(@"vendeur")] ;		// identifiant vendeur
	lectrID = [self numIdentifie:machine(@"lectRub")] ;		// identifiant type machine

	slosyn_initialize() ;									// initialise
	beurk = slosyn_open(&handle) ;							// pas d'erreur, ouvre le device
	present = beurk == SLOSYN_ERROR_SUCCESS ;
	if (!present)
		[self show_alarms:beurk] ;

	[self setTimer: [NSTimer scheduledTimerWithTimeInterval: 0.5		// lance le timer qui vérifie la présence. */
													 target: self
												   selector: @selector(testPresent:)
                                                   userInfo: nil
                                                    repeats: YES]];		// */
	[self devalide:YES] ;												// arret de la queue????
	[self blocRuban] ;
	enCours = NO ;
}

- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender
{
	if (enCours) 
		return NSTerminateCancel ;
		
	
	return NSTerminateNow ;
}

- (void)replyToApplicationShouldTerminate:(BOOL)shouldTerminate
{
	return ;
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
	if (handle != NULL) slosyn_close(handle) ;
	[self prefere:NO]; 
}

- (BOOL)windowShouldClose:(id)sender
{
	if (sender == o_Prefer)
	 {
		return YES ;
	 } ;
	if (enCours) 
		return NO ;													// ne pas fermer, travail en cours
	if (sender == o_fenetre)
	 {	[o_consol fermeConsole] ;									// ferme la console si ouverte
		if ([o_Prefer isVisible])
			[o_Prefer orderOut:self] ;
		[NSApp terminate:self] ;
	 }
	
	return YES ;													// fermer l'appli
}

- (void)blocRuban
{
BOOL blocRuban ;

	blocRuban = [o_combien selectedColumn] == 0 ;
	[o_bCR setEnabled:blocRuban] ;			// CR
	[o_bLF setEnabled:blocRuban] ;			// LF ou CRLF
	[o_bETX setEnabled:blocRuban] ;			// end of text
	[o_bEOT setEnabled:blocRuban] ;			// end of transmission
	[o_bETB setEnabled:blocRuban] ;			// Fin bloc
	[o_bEM setEnabled:blocRuban] ;			// Fin medium
	[o_bFS setEnabled:blocRuban] ;			// File separator
	[o_bGS setEnabled:blocRuban] ;			// Group separator
	[o_bRS setEnabled:blocRuban] ;			// Record separator
	[o_bUS setEnabled:blocRuban] ;			// Unit separator
}

- (void)laLecture:(BOOL)tester
{
	if (present)
	 {	if (!enCours)
		 {	if ([o_Prefer isVisible])
				[o_Prefer orderOut:self] ;
			stop = NO ;								// pas d'arret
			[self devalide:NO] ;
			entest = tester ;
			[self lecture] ;
		 } ;
	 }
	else 
	 {	[o_lire setState:0] ;
		[self devalide:YES] ;
		stop = YES ;								// ici Arret pas de lecteur
		[NSApp auFeu:localiser(@"erreur05") bouton:nil icon:iCone] ;
	 } ;
}

// -------------------------------------------------------------------------------
//	timer:
// -------------------------------------------------------------------------------
- (NSTimer *)timer
{
    return [timer retain] ;
}

// -------------------------------------------------------------------------------
//	setTimer:value
// -------------------------------------------------------------------------------
- (void)setTimer:(NSTimer *)value
{
    if (timer != value)
	{
        [timer release];
        timer = [value retain];
    }
}

- (void)testPresent:(NSTimer*)t										// détection de présence du lecteur
{

	if (!present)
	 {	beurk = slosyn_open(&handle) ;
		present = beurk == SLOSYN_ERROR_SUCCESS ;
	 } ;

	if (present)
	 {	if (([[queue operations] count] == 0) && fini )					// terminé ?
		 {
			[queue cancelAllOperations] ; fini = NO ;
		 } ;

		if (!enCours)
			beurk = (find_slosyn_device()==0) ? SLOSYN_ERROR_SUCCESS : SLOSYN_ERROR_NOT_FOUND ;
	
		present = beurk == SLOSYN_ERROR_SUCCESS ;
		if (!present) enCours = NO ;
	 } ;

	//NSLog(@"%@", (present ? @"OUI": @"--") ) ;
	[o_etat setTextColor:present ? [NSColor blackColor] : [NSColor redColor] ] ;
	[o_etat setStringValue:present ? brancher : debrancher ] ;		// */
	sentpre = present ; 
}

// -----------------------------------------------------------------------------

- (void)devalide:(BOOL)valide										// controle l'accès aux boutons
{
	[o_aret setEnabled:!valide] ;
	[o_lire setEnabled:valide] ;
	[r_code setEnabled:valide] ;
	[r_hexa setEnabled:valide] ;
	[r_sens setEnabled:valide] ;
	[o_combien setEnabled:valide] ;									// */
	[o_fenetre display] ;
}

- (BOOL)show_alarms:(sloSyn_error)bourf
{
	return [self show_alarms:bourf stop:YES] ;
}

- (BOOL)show_alarms:(sloSyn_error)burf stop:(BOOL)stpt
{
NSString *tip, *tap ;
NSAlert  *lalert ;
NSInteger selct ;

	[o_etat setTextColor:present ? [NSColor blackColor] : [NSColor redColor] ] ;
	[o_etat setStringValue:present ? brancher : debrancher ] ;  

	tap = stpt ? localiser(@"quit") : @"" ;
	
	switch (burf) {
	case SLOSYN_ERROR_ALREADY_INIT : tip = localiser(@"erreur10") ;
		break ;
	case SLOSYN_ERROR_LIBUSB : tip = localiser(@"erreur09") ;
		break ;
	case SLOSYN_ERROR_NOT_INIT : tip = localiser(@"erreur03") ;
		break ;
	case SLOSYN_ERROR_NOT_FOUND : tip = localiser(@"erreur04") ;
		break ;
	case SLOSYN_ERROR_MEMORY : tip = localiser(@"erreur08") ;
		break ;
	case SLOSYN_ERROR_TIMEOUT : tip = localiser(@"erreur07") ;
		break ;
	case SLOSYN_ERROR_IO : tip = localiser(@"erreur11") ;
		break ;
	case SLOSYN_ERROR_EINVAL : tip = localiser(@"erreur12") ;
		break ;
	default : return NO ;
	} ;

	lalert = [NSAlert alertWithMessageText:localiser(@"defoTitre") defaultButton:@"Ok" 
						alternateButton:localiser(@"quit") otherButton:nil informativeTextWithFormat:@"%@",localiser(tip) ] ;

    selct = [lalert runModal] ;
	if (selct == NSAlertAlternateReturn) 
	 {	enCours = NO ; fini = YES ;
		[NSApp terminate:self] ;	} ;						// quitter le programme ?
	return NO ;
}

// -------------------------------------------------------------------------------
// travail réel
// -------------------------------------------------------------------------------

- (void)lanceOp															// lance la queue d'opération.
{
slosynqe1	*creve ;													// l'objet alloué

	[queue cancelAllOperations];
	
	creve = [[slosynqe1 alloc] initialise:arret							// entest supprime les conditions d'arrêt
										ff: ((([o_bff state] != 1) || entest) ? 0 : ct_Cff)  
										nul:((([o_b00 state] != 1) || entest) ? 0 : ct_C00)
										sns:[r_sens state]  
										binr:(([r_hexa state] == 1) || entest)
										masq:(entest ? 0xff : [o_consol masque])
										operationClass:[slosynqe2 class]  queue:queue] ;

	[queue setMaxConcurrentOperationCount:4] ;
	[queue addOperation:creve];									// lance l'exécution
	
	[creve release] ;
}																// */

- (void)lecture
{
	if (!present)
	 {	[NSApp auFeu:localiser(@"erreur05") bouton:nil icon:iCone] ;	// appareil est présent ?
		return ; 
	 } ;																//       
	[self prefere:NO] ;													// sauve les réglages 
	[self devalide:NO] ;												// fige les boutons
	if (([o_combien selectedColumn] == 0) && !entest)
		[o_consol carArret:reg dest:arret] ;							// liste des caractères d'arrêt et des réglages
	else 
		arret[0] = arret[1] = 0 ;
	enCours=YES ;
	stop = fini = NO ;
	
	[self lanceOp] ;													// lancer l'opération

//  le timer marche déjà! 
//	enCours=NO ;														// ne pas changer ici
//  [self devalide:YES] ;												// ne pas utiliser ici
}  


// Recevoir les notifications ----------------------------------------------------

// -------------------------------------------------------------------------------
//	anyThread_handle:note
//
//	This method is called from any possible thread (any NSOperation)
//	The notification contains the NSDictionary 
// -------------------------------------------------------------------------------
- (void)anyThread_handle:(NSNotification *)note
{
	[self performSelectorOnMainThread:@selector(mainThread_handle:) withObject:note waitUntilDone:YES];
}

// -------------------------------------------------------------------------------
//	mainThread_handle:note
//
//	note est le dictionnaire des informations à traiter.
//	The notification contains an NSDictionary
// -------------------------------------------------------------------------------
- (void)mainThread_handle:(NSNotification *)note				
{
NSInteger	module ;
NSInteger	nbre ;

	module = [[[note userInfo] objectForKey:@"module"] integerValue] ;		// code de l'envoi
	if ((fini = module != 0) == YES)										// dernier envoi si YES
	 {	[queue cancelAllOperations] ;
		[self devalide:YES] ; } ;			
	nbre = [[[note userInfo] objectForKey:@"nbre"] integerValue] ;			// nbr de caractère
	if (nbre != 0)															// envoi à l'affichage
		[o_consol nextChar:[[note userInfo] objectForKey:@"donet"] why:entest] ;
	enCours = module == 0 ;
}

@end
