//
//  Console.h
//  SLOSYN
//
//  Créé par Miguel Saro le 03/04/12.
//  Tout droits réservés, __La Torréfaction Joyeuse__, 2012.
//

#import <Cocoa/Cocoa.h>
#import "AppServices.h"


@interface Console : NSObject <NSOpenSavePanelDelegate>
{

    IBOutlet NSButton			*o_hexa ;			// binaire <> code (affichage)
    IBOutlet NSButton			*o_code ;			// choix du code
    IBOutlet NSTextField		*o_nomc ;			// nom du code
	IBOutlet NSWindow			*o_display ;		// la fenêtre
	IBOutlet NSScrollView		*o_scrl ;			// scrollview
	IBOutlet NSTextView			*o_Text ;			// affichage texte.
	IBOutlet NSView				*o_lavue ;			// sauve Brut ou Text ou rtf
	IBOutlet NSPopUpButton		*o_choix ;			// PopUp Brut ou Text ou rtf
	IBOutlet NSView				*o_append ;			// ajoute/remplace les données
	IBOutlet NSPopUpButton		*o_ajout ;			// PopUp ajoute/remplace

	NSSavePanel					*choix_fichier ;	// sauver fichier
	NSMutableString				*chemin ;			// son chemin
	
	NSOpenPanel					*choix_donnee ;		// lire fichier
	NSMutableString				*mechin ;			// son chemin
	
	NSMutableData				*brut ;				// Cumule les caractères reçus
	NSMutableData				*fuori ;			// intermédiaire sauver, relire, afficher

	NSMutableString				*defoCode ;			// path du fichier de code
	NSMutableString				*nameCode ;			// nom du code 
	NSMutableArray				*tmpArray ;			// liste des codes dans l'ordre du fichier
	NSMutableAttributedString	*strtf	  ;			// utilisé pour la génération du rtf
	
	NSInteger					shiftHow ;			// valeur à ajouter
	BOOL						isLET ;				// shift à faire si YES
	NSUInteger					tablmask ;          // un mask
	UInt16						tablpari ;			// Numéro du bit de parité ??
	unichar						tableCd[512] ;		// la table des caractères de transcodage
	BOOL						textatt ;

#define Lx 3
	UInt8	LFr[Lx], CRr[Lx], ETXr[Lx], EOTr[Lx], ETBr[Lx], EMr[Lx], FSr[Lx], GSr[Lx], RSr[Lx], USr[Lx] ;
	UInt8   arret[30] ;
	char						subs ;				// caractère de substitution
	char						FIGu ;				// shiftin ou figure
	char						LETr ;				// shiftout ou lettre
	char						baks ;				// back space
	BOOL						Bac ;
	char						soul ;				// souligné
	BOOL						Sou  ;
	NSColor						*red ;				// couleur rouge
	NSInteger					colr ;
	char						axen[4] ;           // 4 accents ou leur substitution ??
	NSInteger					invar ;				// nombre de caratères inchangés par UC-LC

	char						recu[80] ;
	unichar						Recus[60] ;
	NSInteger					nomb ;
	BOOL						MAJ ;
	NSMutableString				*lu ;
	NSCharacterSet				*majuscules, *axents ;
	NSSound						*tagada ;
	SInt16						nV ;
	NSFont						*lafonte ;
	NSDictionary				*attr ;
	NSMutableDictionary			*atts ;
	BOOL						rtf ;				// YES si sauve NO si affiche
	BOOL						atri ;
	BOOL						cetest ;
	uint8						lordre[8] ;
	BOOL						order ;
}

- (IBAction)changeCode:(id)sender ;		// changer le code
- (IBAction)a_sauver:(id)sender ;		// sauver les données
- (IBAction)a_relire:(id)sender ;		// relire un fichier de données
- (IBAction)a_ascii7:(id)sender ;		// mettre le code par défaut
- (IBAction)a_codage:(id)sender ;		// voir les caractères du code
- (IBAction)a_efface:(id)sender ;		// effacer la console
- (IBAction)a_hexade:(id)sender ;		// binaire<->texte
- (IBAction)a_chExtn:(id)sender ;		// choix extension

- (void)consolInit ;
- (void)nextChar:(NSData *)ceschar why:(BOOL)why ;
- (void)fermeConsole ;

- (NSString *)defoCode ;
- (void)setDefoCode:(NSString *)Kode ;
- (NSString *)chemin ;
- (void)setChemin:(NSString *)Kode ;
- (NSString *)mechin ;
- (void)setMechin:(NSString *)Kode ;
- (void)carArret:(reglages)regl dest:(UInt8 *)dest ;
- (void)affih:(NSString *)aVoir ;
- (NSUInteger)masque ;
- (void)attributs:(NSInteger)quel ;

@end
