/*
** Made by fabien le mentec <texane@gmail.com>
** 
** Started on  Wed Nov 11 17:09:47 2009 texane
** Last update Sat Nov 21 09:03:20 2009 texane
*/


#ifndef M600_H_INCLUDED
# define M600_H_INCLUDED

// m600_get_state   m600_init  find_m600_device alarms_to_bitmap  error_to_bitmap

#include <stdint.h>
#include <stdbool.h>
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;


extern m600_handle_t	*myhandle ;
extern m600_alarms_t	alarms;

/* interface */

// endiannes
uint16_t le16_to_mach(uint16_t n) ;

// prise de l'tat de la machine et de l'usb
m600_bitmap_t  m600_get_state() ;

// comme c'est dit: initialisation
m600_error_t  m600_Init() ;

// traite les erreurs
m600_bitmap_t  alarms_to_bitmap(m600_alarms_t alarms) ;
m600_bitmap_t error_to_bitmap(m600_error_t error) ;

// retourne YES si le lecteur est trouv
bool find_m600_device() ;

// test m600 prsent   (1)
int find_m600_dev() ;

// comme c'est dit: initialisation
m600_error_t m600_initialize(void) ;

// netoyage de ??
void m600_cleanup(void) ;

// ouverture du priphrique
m600_error_t m600_open() ;

// fermeture du priphrique
void m600_close() ;

// lecture des alarmes      (1)
m600_error_t m600_read_alarms() ;

// lire une carte 
//m600_error_t m600_read_cards(unsigned int, m600_cardfn_t, void*) ;

// send_recv_cmd or reopen handle on libusb failure
m600_error_t send_recv_cmd_or_reopen( m600_handle_t* handle, m600_cmd_t* cmd) ;

// ??
m600_error_t m600_fill_data(uint16_t*) ;

// lecture des ports du PIC   (1)
m600_error_t m600_read_pins(uint8_t*) ;

// m600 opened ?
bool isM600Open() ;

// reset l'interface ?
m600_error_t m600_reset() ;

m600_error_t is_m600_ready(bool *is_ready) ;


#endif /* ! M600_H_INCLUDED */
