/*
 *  m_600_common.h
 *  Lecteur
 *
 *  Créé par Fabien Le Mentec   <texane@gmail.com>
 *  modifié par M Saro le 11/05/10.
 *  Droits réservés par __La Torréfaction Joyeuse__, 2006-2010.
 *
 */
 
#ifndef M600_H_COMMUN
#define M600_H_COMMUN

#include "def.h"
#include "usb.h"
#include "stdint.h"

// common/m600.h ______________________________________________________

#define M600_USB_VENDOR_ID 0x2a2a
#define M600_USB_PRODUCT_ID 0xf00f

#define M600_USB_EP_REQ 1
#define M600_USB_EP_REP 2

//m600_types.h  _______________________________________________________

/* include stdint before */

/* utility macro */

#define GOTO_ERROR(E)	\
  do {			\
    error = E;		\
    goto on_error;	\
  } while (0)

/* alarms */

#define M600_ALARM_NONE 0

#define M600_ALARM_ERROR 0
#define M600_ALARM_HOPPER_CHECK 1
#define M600_ALARM_MOTION_CHECK 2
#define M600_ALARM_NOT_READY 3
#define M600_ALARM_MAX 4

#define M600_SET_ALARM(A, B) do { A |= 1 << M600_ALARM_ ## B; } while (0)
#define M600_IS_ALARM(A, B) ((A) & (1 << M600_ALARM_ ## B))
#define M600_IS_SINGLE_ALARM(A, B) (A == (1 << M600_ALARM_ ## B))
#define M600_OTHER_ALARM(A, B) (A &= ~(1 << M600_ALARM_ ## B))

typedef uint16_t m600_alarms_t;


/* for testing, 4 ports * 8 pins */

#define M600_PIN_COUNT 32

/* protocol related types */

#define M600_REQ_READ_CARD 0
#define M600_REQ_READ_ALARMS 1
#define M600_REQ_FILL_DATA 2
#define M600_REQ_READ_PINS 3
#define M600_REQ_RESET_DEV 4
#define M600_REQ_INVALID (m600_request_t)-1
typedef uint8_t m600_request_t;

#define M600_COLUMN_COUNT 80

struct m600_reply
{
  m600_alarms_t alarmes;
  //  little endian 
  uint16_t card_data[M600_COLUMN_COUNT];
} 

#ifndef SDCC
__attribute__((packed))
#endif
;

typedef struct m600_reply m600_reply_t ;

//  autre ___________________________________________________________


enum m600_error
  {
    M600_ERROR_SUCCESS = 0,
    
    M600_ERROR_ALREADY_INIT,
    M600_ERROR_LIBUSB,
    M600_ERROR_NOT_INIT,
    M600_ERROR_NOT_FOUND,
    M600_ERROR_MEMORY,
    M600_ERROR_TIMEOUT,
    M600_ERROR_IO,
	M600_ERROR_STOP,

    M600_ERROR_MAX
  };

typedef enum m600_error m600_error_t ;

/* error bitmap */
typedef unsigned int m600_bitmap_t;

#define M600_BIT_NO_ERROR 0			// pas d'erreur (c'est Lessieur)
#define M600_BIT_ERROR 1			// il y a une erreur USB
#define M600_BIT_UNDEF 2			// undefined error
#define M600_BIT_IO 4				// communication (usb) error
#define M600_BIT_M600_ERROR 8		// generic error  m600 
#define M600_BIT_HOPPER_CHECK 16	// hopper is empty
#define M600_BIT_MOTION_CHECK 32	// erreur déplacement
#define M600_BIT_NOT_CONNECTED 64	// device not connected
#define M600_BIT_NOT_READY 128		// device not ready
#define M600_BIT_USER 256			// arret utilisateur   */

typedef int (*m600_cardfn_t)(const uint16_t*, m600_alarms_t, void*);

/* définition m600 handle */

struct m600_handle {
  usb_dev_handle *usb_handle;
  unsigned int ep_req;
  unsigned int ep_rep;
} ;

typedef struct m600_handle  m600_handle_t ;


/* m600 command */

union m600_cmd
{
  m600_request_t req;
  m600_reply_t rep;
} ;

typedef union m600_cmd m600_cmd_t;

#endif

