//
//  AppServices.m     divers services
//  
//
//  Créé par M Saro le 26/08/06.
//  modifié le 01/05/10.
//  Droits réservés par __La Torréfaction Joyeuse__, 2006-2010.
//
// cette catégorie attachée à l'application contient des méthodes générales.
//
// carriage return
#define K_cr	13
// line feed
#define K_lf	10
// line separator
#define K_ls	8232
// Paragraph separator
#define K_ps	8233


#import "AppServices.h"

// NSApplication 
// =============

@implementation NSApplication (AppServices)

// Prise du chemin (garde uniquement les dossiers)
//
- (NSString *)SaVoie:(NSString *)CeChemin
{
	return [CeChemin stringByDeletingLastPathComponent]  ;
}

// retourne le chemin localisé
//
- (NSString *)localpath:(NSString *)celuila							
{
	NSFileManager *gestion = [NSFileManager defaultManager] ;					// call "default manager"
	return [self localpath:celuila :gestion] ;
}

- (NSString *)localpath:(NSString *)cuila :(NSFileManager *)gerer				// réentrante
{
NSString	*lafin ;
NSArray		*Les_composantes ;

	if (cuila == nil) return @"" ;
	if ([cuila length] == 0) return @"" ;
	if (![gerer fileExistsAtPath:cuila])
	 {	lafin = [cuila lastPathComponent] ;
	 	return [[self localpath:[cuila stringByDeletingLastPathComponent] :gerer] stringByAppendingPathComponent:lafin] ;
	 } ;

	Les_composantes = [gerer componentsToDisplayForPath:cuila] ;			// convert in matrix
	return [NSString pathWithComponents:Les_composantes] ;					// return localized path
}

- (NSString *)pathUser:(NSString *)celuici
{
NSString *ici ;
NSString *chemin ;

	chemin = [self localpath:celuici] ;
	if ([chemin length] == 0) return @"" ; 
	ici = [self localpath:[@"~/" stringByExpandingTildeInPath]] ;
	if (([chemin rangeOfString:ici].location) != 0) return chemin ;
	return [NSString stringWithFormat:@"~%@", [chemin substringFromIndex:[ici length]]] ;
}

- (NSString *)lURL:(NSString *)CeChemin
{
	return [CeChemin stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding ] ;
}

// saisie des fichiers/dossiers _______________________________________________________________________________
/* documentation
	NSArray *fileTypes = [NSArray arrayWithObjects: @"txt", @"text", NSFileTypeForHFSTypeCode( 'TEXT' ), nil];
*/
// choix d'un dossier existant (ou à créer)
// choix d'un fichier existant
//
- (NSString *)prise_Dossier:(NSString *)titre :(BOOL)newFold :(BOOL)fichier :(NSArray *)lesTypes
{
	return [self prise_Dossier:titre :newFold :fichier :lesTypes :nil] ;
}

- (NSString *)prise_Dossier:(NSString *)titre :(BOOL)newFold :(BOOL)fichier :(NSArray *)lesTypes :(NSString *)pak
{
NSOpenPanel *choix_dossier ;
NSArray		*les_fichiers ;
NSUInteger	quoi ;

	choix_dossier = [NSOpenPanel openPanel] ;				// créé l'objet openPanel
	choix_dossier.canChooseFiles = fichier ;				// pas de fichier
	choix_dossier.canChooseDirectories = !fichier ;			// dossier oui
	choix_dossier.resolvesAliases = NO ;					// ne pas resoudre les alias
	choix_dossier.allowsMultipleSelection = NO ;			// pas de sélection multiple
	choix_dossier.message = localiser(titre)  ;				// choisir un dossier
	choix_dossier.canCreateDirectories = newFold ;			// nouveau dossier possible

	if (pak == nil)
	 	choix_dossier.allowedFileTypes = lesTypes  ; 
	else
		{ choix_dossier.allowedFileTypes = lesTypes  ;
		  choix_dossier.directoryURL = [NSURL fileURLWithPath:[pak stringByDeletingLastPathComponent]]  ; }
		
	quoi = [choix_dossier runModal] ;
	if (quoi == NSFileHandlingPanelCancelButton) return (@"") ;					// annulé par l'utilisateur
	les_fichiers = [choix_dossier URLs] ;										// récupère la matrice des noms
	if ( [les_fichiers count] == 0) return (@"") ;								// matrice vide ?
	return [NSString stringWithString:[[les_fichiers objectAtIndex:0] path]] ;	// retourne le dossier
}


// Prise des informations sur le fichier.
// retourne YES si c'est un Dossier, NO dans les autres cas
//
- (BOOL)estDossier:(NSString *)leChemin
{
NSString			*leNom ;								// le nom à afficher
char				perdu[256]	;							// tampon pour des prunes
int					linfo ;

	leNom = [leChemin lastPathComponent] ;					// extrait le nom à afficher.
	
	linfo = [self InfoFichier:leChemin :leNom :perdu] ;
	
	if ((linfo  &  0xf) == is_container) return (YES) ; 
	
	return (NO) ;      
} 

// relation entre deux chemins (chemins de dossiers en principe)
// 0 pas de relation, 1 path1 et path2 vides, 2 path1 == path2
// 3 path1 contient path2, 4 path2 contient path1
// pas de test de l'existence des chemins!
//
- (int)relationChemin1:(NSString *)chemin1 chemin2:(NSString *)chemin2
{
	if (([chemin1 length] == 0) && ([chemin2 length] == 0)) return 1 ;
	if ([chemin1 isEqualToString:chemin2]) return 2 ;
	if ([chemin1 rangeOfString:chemin2].location == 0) return 3 ;
	if ([chemin2 rangeOfString:chemin1].location == 0) return 4 ;
	return 0 ;
}

// affichage d'un message d'alerte
//
- (void)auFeu:(NSString *)erreur defBouton:(NSString *)label
{
    [self auFeu:erreur  titre:nil defBouton:label bouton1:nil bouton2:nil icon:nil ]  ;
}

// affichage d'un message d'alerte avec une icone spécifique
//
- (void)auFeu:(NSString *)erreur defBouton:(NSString *)label icon:(NSImage *)licone
{
    [self auFeu:erreur  titre:nil defBouton:label bouton1:nil bouton2:nil icon:licone ]  ;
}

// affichage d'un message d'alerte avec une icone spécifique
//
- (void)auFeu:(NSString *)erreur bouton:(NSString *)label icon:(NSImage *)licone
{
    [self auFeu:nil  titre:erreur defBouton:label bouton1:nil bouton2:nil icon:licone ]  ;
}

// affichage paramétré d'un message d'alerte
// si un des parametre est "nil" l'objet correspondant est supprimé ou remplacé par l'objet par défaut.
//
- (void)auFeu:(NSString *)lerreur titre:(NSString *)titre defBouton:(NSString *)label0 bouton1:(NSString *)label1 bouton2:(NSString *)label2 icon:(NSImage *)licone 
{
NSString *tip, *tap, *top, *tup, *tep ;
NSAlert  *lalert ;

	tip = [NSString stringWithString:localiser(titre == nil ? @"defoTitre" : titre) ] ;
	tap = [NSString stringWithString:label0 == nil ? @"Ok" : localiser(label0) ] ;
	top = label1 == nil ? nil : [NSString stringWithString : localiser(label1) ] ;
	tup = label2 == nil ? nil : [NSString stringWithString : localiser(label2) ] ;
	tep = lerreur == nil ? @" " : lerreur ;
    lalert = [NSAlert alertWithMessageText:tip  defaultButton:tap  alternateButton:top  otherButton:tup  informativeTextWithFormat:@"%@", tep ] ;

	if (licone != nil)
		[lalert setIcon:licone] ;
		
    [lalert runModal] ;
}

// prise des informations sur un fichier
//
- (int)InfoFichier:(NSString *)lechemin :(NSString *)leNom :(char *)leType
{
BOOL				i ;
int					j ;
long				ret;
FSRef				fRef;
CFStringRef			LaSorte = NULL ;
LSItemInfoRecord	monEnreg ;  
char				filePathStr[1024] ;
NSFileManager		*gestion ;
NSDictionary		*Luiattrs ;


	leType[0] = 0 ;
	gestion = [NSFileManager defaultManager] ;
	
	i = NO ;
	j = 0 ;
	Luiattrs =[gestion attributesOfItemAtPath:lechemin error:NULL] ;				// prise attributs
	i = [[Luiattrs fileType] compare:NSFileTypeSymbolicLink] == NSOrderedSame ;		// lien unix

	strcpy(filePathStr,[lechemin UTF8String]) ;
	ret=FSPathMakeRef((const UInt8*)filePathStr,&fRef, 0) ;
	if (i)
	 {	if (ret == 0) 
			j = is_hardlink ;
		else
			j = is_symblink ;
			
		if ([leNom characterAtIndex:0] != [@"."  characterAtIndex:0])  return (j) ;
		
		return (j | is_invisible) ;
	 } ;
		
	if (LSCopyItemInfoForRef (&fRef, kLSRequestAllFlags + kLSRequestTypeCreator , &monEnreg))
				return is_erreur ;																// erreur !!
	 	
	if (!ret) ret = LSCopyKindStringForRef(&fRef, &LaSorte) ;
	if (!ret) CFStringGetCString ((CFStringRef)LaSorte, leType, 250, kCFStringEncodingUTF8) ;	// KindString
	CFRelease(LaSorte) ;

	return (monEnreg.flags & is_filtre) ;
}

// transfert string dans Data ;
//
- (void)stringTexte:(NSString *)xString letexte:(NSMutableData *)xtexte
{
unichar		lesCars[480] ;
long	x, y ;

	if (xString == nil) return ;									// pas de string
	if ((y = [xString length]) == 0) return ;
	for (x = 0 ; x<y ; x++)
		lesCars[x] = [xString characterAtIndex:x] ;					// buffer contient le string
	x = y*sizeof(unichar) ;
	[xtexte appendBytes:(const void *)lesCars length:x] ;			// copie buffer dans les Data
}

// création texte de type .plist
// "xxx" = "yyyyyyy" ;
- (void)stringTexte:(NSString *)xString letexte:(NSMutableData *)xtexte leFlag:(BOOL)xFlag
{
	[self stringTexte:xString letexte:xtexte leFlag:xFlag comment:@""] ;
}

// création texte de type .plist
// "xxx" = "yyyyyyy" ;
- (void)stringTexte:(NSString *)leString letexte:(NSMutableData *)letexte leFlag:(BOOL)leFlag comment:(NSString *)comment
{
unichar			lesCars[256], kr ;
int				x, z ;
long		y ;
NSString		*lafin ;

	if (leString == nil) return ;												// pas de string
	if ([leString length] == 0) return ;
	
	y = 0 ;
	if (leFlag) 
	 {	lesCars[y++] = (unichar)'=' ; lesCars[y++] = (unichar)' ' ; } ;
	lesCars[y++] = (unichar)'"' ;												// début string

	if (((leString != nil) && (z=[leString length]) != 0))						// string vide ou absent?
	 {	for (x=0 ; x<z ; x++)
		 {	switch (kr = [leString characterAtIndex:x]) {
			case K_lf: lesCars[y++] = (unichar)'\\' ; lesCars[y++] = (unichar)'n' ; break ;	// carriage return
			case K_cr:
			case K_ls:
			case K_ps: lesCars[y++] = (unichar)'\\' ; lesCars[y++] = (unichar)'r' ; break ;		// line feed
			case '\\': lesCars[y++] = (unichar)'\\' ; lesCars[y++] = (unichar)'\\' ; break ;	// backSlash
			case '\"': lesCars[y++] = (unichar)'\\' ; lesCars[y++] = (unichar)'\"' ; break ;	// guillemets
			case '\'': lesCars[y++] = (unichar)'\\' ; lesCars[y++] = (unichar)'\'' ; break ;	// apostrophe
			case '\t': lesCars[y++] = (unichar)'\\' ; lesCars[y++] = (unichar)'t' ; break ;		// tabulation
			case '\b': lesCars[y++] = (unichar)'\\' ; lesCars[y++] = (unichar)'b' ; break ;		// Backspace
			case '\f': lesCars[y++] = (unichar)'\\' ; lesCars[y++] = (unichar)'f' ; break ;		// form feed
			case   0 : break ;
			default : lesCars[y++] = kr ; break ;
			} ;
			if (y >= 230) 
			 {	y = y*sizeof(unichar) ;
				[letexte appendBytes:(const void *)lesCars length:y] ;			// vider le buffer plein
				y = 0 ;
			 } ;
		 } ;
	 } ;
	if (leFlag)
	 {	if ([comment length] != 0)												// fin string
			lafin = [NSString stringWithFormat:@"\" ;   //%@\r", comment];		// avec commentaire
		else
			lafin = @"\" ;\r";						// sans commentaire
	 }
	else
		lafin = @"\" " ;

	for (x=0 ; x<[lafin length] ; x++)
	 {	lesCars[y++] = [lafin characterAtIndex:x] ;
		if (y >= 230) 
		 {	y = y*sizeof(unichar) ;
			[letexte appendBytes:(const void *)lesCars length:y] ;				// vider le buffer plein
			y = 0 ;
		 } ;
	 } ;
	if (y>0)
	 {	y = y*sizeof(unichar) ;
		[letexte appendBytes:(const void *)lesCars length:y] ;					// vider le buffer si pas vide
	 } ;
}

// crée un fichier et return un file-handle
//
- (NSFileHandle *)handleInit:(NSString *)chemin
{
	if ([[NSFileManager defaultManager] createFileAtPath:chemin contents:[NSData data] attributes:nil ])
		return [NSFileHandle fileHandleForWritingAtPath:chemin ] ;
	return nil ;
}
 
// écrit un texte dans un fichier.
// 
// codé utf-16
- (BOOL)ecritUtf16:(NSString *)chemin letexte:(NSString *)letexte
{
NSData			*mesdata ;

	mesdata = [letexte dataUsingEncoding:NSUnicodeStringEncoding] ;
	return [[NSFileManager defaultManager] createFileAtPath:chemin contents:mesdata attributes:nil] ;
}

// codé utf-8
- (BOOL)ecritUtf8:(NSString *)chemin letexte:(NSString *)letexte
{
NSData			*mesdata ;

	mesdata = [letexte dataUsingEncoding:NSUTF8StringEncoding allowLossyConversion:YES] ;	
	return [[NSFileManager defaultManager] createFileAtPath:chemin contents:mesdata attributes:nil] ;
}

@end


