//
//  m600a.m
//  Datamation
//
//  Créé le 10/10/13 par Miguel Saro.
//  Tout droits réservés par - Cocoa Pod -, 2013.
//

#include "m600_common.h"
#include "m600.h"
#include "m600a.h"
#include "m600b.h"
#include "externes.h"

extern m600_alarms_t	alarms;
extern int nbrCarte, crtCarte, suivi ;
extern uint16_t *badPtr ;

extern BOOL stopit ;
extern BOOL uneCrt ;

@implementation m600a

- (id)initialise:(Class)cc queue:(NSOperationQueue *)qq
{
	self = [super init];
    if (![cc instancesRespondToSelector:@selector(initialise:nbre:k80:)])
	 {
		[self release];
		return nil;
     } ;
	queue = [qq retain];
	return self;
}

- (void)dealloc
{
    [queue release];
    [super dealloc];
}

- (void)main
{
NSAutoreleasePool	*pool ;
m600_error_t	error;
m600_bitmap_t	bitmap;
m600b			*m600bObj ;
bool			pret ;
NSInteger		nbr ;
m600_cmd_t		cmd ;

	pool = [[NSAutoreleasePool alloc] init];
	pret = false ;

	do {
	carte[0] = 0 ;
	bitmap  = error = nbr = 0 ;
	
// ---------------------------------------------------------------------
#ifndef simlCarte

	NSLog(@"num log %d",1) ;
	error = m600_read_alarms() ;									// check for device alarms */
	if (error != M600_ERROR_SUCCESS)
		GOTO_ERROR(error);

	if ( alarms != M600_ALARM_NONE )
	{
		if (M600_IS_SINGLE_ALARM(alarms, NOT_READY))				// reset the device if not ready
		{
			error = m600_reset() ;									// do reset
			if (error != M600_ERROR_SUCCESS)
				GOTO_ERROR(error);
			
			for (nbr=0 ; nbr<8 ; nbr++)
			 {														// delais+test  de 8 secondes
				error = is_m600_ready(&pret) ;
				if (error != M600_ERROR_SUCCESS)
								GOTO_ERROR(error);
				if (pret)
				   { exit; } ;
				sleep(1) ;											// A VOIR  delay ou sleep!
			 } ;
		 }
		else
		 {	M600_OTHER_ALARM(alarms, NOT_READY) ;					// si autre alarme que NOT_READY ???????
			GOTO_ERROR(error);
		 } ;
	} ;
	
	cmd.req = M600_REQ_READ_CARD ;
	error = send_recv_cmd_or_reopen(myhandle, &cmd) ;				// lire une carte
	if (error != M600_ERROR_SUCCESS) GOTO_ERROR(error) ;			// erreur ?
	
	for ( nbr=0 ; nbr<M600_COLUMN_COUNT ; nbr++)
		carte[nbr]= ~ le16_to_mach(cmd.rep.card_data[nbr]) ;		// copie le buffer, le -> be
		
// ---------------------------------------------------------------------

#else
uint16_t		*buffer ;

	alarms = M600_ALARM_NONE ;										// simulation fin du paquet
	error = M600_ERROR_SUCCESS ;
	if (suivi >= simlPackt)											// fin paquet?
	  	alarms = 1 << M600_ALARM_HOPPER_CHECK ;
	else
	 {	
		buffer = &(badPtr[crtCarte * M600_COLUMN_COUNT]) ;
		for (nbr = 0 ; nbr < M600_COLUMN_COUNT; nbr++ )
		 {	
			carte[nbr] = buffer[nbr] ;
		 } ;
		suivi++ ;
		crtCarte = (crtCarte+1) % nbrCarte ;
	 } 	;
#endif
// ---------------------------------------------------------------------

on_error:

	if (stopit)  error = M600_ERROR_STOP ;								// stop utilisateur

	if (error == M600_ERROR_SUCCESS)
		bitmap = alarms_to_bitmap(alarms) ;								// pas d'erreur -> lecture des alarmes
	else
	 	bitmap = error_to_bitmap(error) ;								// erreur dans la lecture des alarmes

	m600bObj = [[m600b alloc] initialise:bitmap nbre:nbr k80:carte ] ;	// erreur		
	[m600bObj setQueuePriority: 2.0] ;
	[queue addOperation: m600bObj] ;
	[m600bObj release] ;


	} while (!uneCrt && ((bitmap & (M600_BIT_ERROR | M600_BIT_M600_ERROR)) == M600_BIT_NO_ERROR )) ;
	
	[pool release];
}

@end
