//
//  PolishedWindow.h
//  TunesWindow
//
//  Created by Matt Gemmell on 12/02/2006.
//  Copyright 2006 Magic Aubergine. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface PolishedWindow : NSWindow {
    BOOL _flat ;
    BOOL forceDisplay ;
}

- (id)initWithContentRect:(NSRect)contentRect 
                styleMask:(unsigned int)styleMask 
                  backing:(NSBackingStoreType)bufferingType 
                    defer:(BOOL)flag 
                     flat:(BOOL)flat ;

#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4
- (void)setToolbar:(NSToolbar *)toolbar ; 
#endif
- (void)dealloc ;
- (void)windowDidResize:(NSNotification *)aNotification ;
- (void)setMinSize:(NSSize)aSize ;
- (void)setFrame:(NSRect)frameRect  display:(BOOL)displayFlag  animate:(BOOL)animationFlag ;
- (NSColor *)sizedPolishedBackground ;

- (BOOL)flat ;
- (void)setFlat:(BOOL)newFlat ;

@end
