/*
** Made by fabien le mentec <texane@gmail.com>
** 
** Started on  Wed Nov 11 17:09:47 2009 texane
** Last update Sat Nov 21 09:03:20 2009 texane
*/


#ifndef M600_H_INCLUDED
# define M600_H_INCLUDED



#include <stdint.h>
#include "m600_common.h"



/* forward decls  

typedef struct m600_handle m600_handle_t;


 error types 

enum m600_error
  {
    M600_ERROR_SUCCESS = 0,
    
    M600_ERROR_ALREADY_INIT,
    M600_ERROR_LIBUSB,
    M600_ERROR_NOT_INIT,
    M600_ERROR_NOT_FOUND,
    M600_ERROR_MEMORY,
    M600_ERROR_TIMEOUT,
    M600_ERROR_IO,

    M600_ERROR_MAX
  };

typedef enum m600_error m600_error_t; */

/* error bitmap */
typedef unsigned int m600_bitmap_t;

		/* there is an error */
#define M600_BIT_ERROR 1	
		/* undefined error */
#define M600_BIT_UNDEF 2
		/* communication (usb) error */
#define M600_BIT_IO 4
		/* m600 generic error */
#define M600_BIT_M600_ERROR 8
		/* hopper is empty */
#define M600_BIT_HOPPER_CHECK 16
		/*  */
#define M600_BIT_MOTION_CHECK 32
		/* device not connected */
#define M600_BIT_NOT_CONNECTED 64
		/* device not ready */
#define M600_BIT_NOT_READY 128		



/* card callback */

typedef int (*m600_cardfn_t)(const uint16_t*, m600_alarms_t, void*);


/* interface */

m600_handle_t* alloc_m600_handle(void);

/// prise de l'tat de la machine et de l'usb
m600_bitmap_t  m600_get_statevoidvoid(void) ;

// comme c'est dit: initialisation
m600_error_t  m600_Init(void) ;


// retourne YES si le lecteur est trouv
bool find_m600_device(void) ;

// test m600 prsent   (1)
int find_m600_dev(void) ;

// comme c'est dit: initialisation
m600_error_t m600_initialize(void) ;

// netoyage de ??
void m600_cleanup(void) ;

// ouverture du priphrique
m600_error_t m600_open(void) ;

// fermeture du priphrique
void m600_close(void) ;

// lecture des alarmes      (1)
m600_error_t m600_read_alarms(void) ;

// lire une carte 
//m600_bitmap_t m600_read_cards(unsigned int, m600_cardfn_t, void*) ;
m600_bitmap_t m600_read_card(void) ;

// ??
m600_error_t m600_fill_data(uint16_t*) ;

// lecture des ports du PIC   (1)
m600_error_t m600_read_pins(uint8_t*) ;

// m600 opened ?
bool isM600Open(void) ;

m600_bitmap_t  m600_get_state(void);

// reset l'interface ?
m600_error_t m600_reset(void) ;

#endif /* ! M600_H_INCLUDED */
