//
//  console.m
//
//  Créé par Miguel Saro le 01/05/10.
//  Tout droits réservés, __La Torréfaction Joyeuse__, 2010.  
//


#import "Console.h"
#import "def.h"
#import "m600.h"
#import "AppServices.h"

extern	  uint16_t card_buffer[M600_COLUMN_COUNT] ;

int		  nbrCarte, crtCarte, suivi ;
uint16_t  *badPtr ;

@interface Console (locales)

// transcription ascii de la lecture d'une carte.
- (NSString *)encode:(UInt16 *)bufr ;

// traitements fichier
- (NSString *)priseFichier:(NSString *)defautNom ;
- (NSString *)prise_Donnee:(NSString *)defautNom ;

- (void)fausseCarte:(NSMutableDictionary *)codeur ;				//
- (BOOL)m600_copy_code:(UInt16 *)iBuffr laCarte:(int)laQuelle ;
- (void)m600_copy_buffer:(UInt16 *)iBuffr ;

// prendre les résultats
// afficher un résultat
- (void)faitTexte ;
- (void)faitHexa ;
- (void)afficher ;

@end

@implementation Console

// ----------------------------------------------------------------- connexions GUI

- (IBAction)a_effacer:(id)sender								// effacement console et string.
{
	[o_texte setString:@""] ;
	[paquets setLength:0] ;
	[ self m600_copy_buffer:nil] ;								// simul, efface comptage.
	[montrer setString:@""] ;
}

- (IBAction)a_sauver:(id)sender									// Sauver sous hexa ou texte setIcon:forFile:options:
{
NSString		*sentier ;
NSData			*letexte ;
NSFileManager	*gestion ;
BOOL			result ;
BOOL			leType ;

	if ([paquets length] == 0)
	 {	[NSApp auFeu:[NSApp localiser:@"erreur06"] defBouton:nil ] ;
		return ;
	 } ;
	 
	sentier = [self priseFichier:chemin] ;
	if ([sentier length] == 0) return ;														// annuler par l'utilisateur.
	[chemin setString:[NSString stringWithString:sentier]] ;								//sauve le path
	
	gestion = [NSFileManager defaultManager] ;
	if ((leType = [[chemin pathExtension] isEqualToString:@"brt"]))
	 {	[self faitHexa] ;																	// vleurs en décimales
		letexte = [montrex dataUsingEncoding:NSASCIIStringEncoding] ;						// en faire un NSData
	 }
	else
	 {	[self faitTexte] ;																	// refait le texte complet
		letexte = [montrer dataUsingEncoding:NSUnicodeStringEncoding] ;						// en fait un NSData
	 } ;
	result = [gestion createFileAtPath:sentier contents:letexte attributes:nil] ;			// sauve le fichier
	if (leType)
		[[NSWorkspace sharedWorkspace] setIcon:laCarte forFile:sentier 
							options:NSExcludeQuickDrawElementsIconCreationOption] ;			// met l'icone
}

- (IBAction)a_relire:(id)sender
{
NSString		*sentier ;
unsigned		ttl, x, y ;
NSMutableData	*dataLus ;
UInt16			*uitPtr, val ;					
unsigned char	car1 ;
Byte			*dBuf ;
BOOL			pasHexa ;

	sentier = [self prise_Donnee:mechin] ;
	if ([sentier length] == 0) return ;										// user canceled
	append = (int)[o_ajout indexOfSelectedItem] ;								// ajout ou remplace ?
	
	dataLus = [NSMutableData dataWithCapacity:100] ;
	[dataLus setData:[NSData dataWithContentsOfFile:sentier]] ;				// données lues -> NSData
	ttl = (unsigned)[dataLus length] ;												// Longueur des données
	[dataLus increaseLengthBy:20] ;											// ajoute Bytes de sécurité
	if (ttl < 160) return ;													// longueur < données d'une carte vierge
	dBuf = (Byte *)[dataLus bytes] ;										// pointeur des données scanf hexa
	uitPtr = (UInt16 *)dBuf ;
	
	for (x=0, y=0 ; x<ttl ; )
	 {	pasHexa = NO ;
		val = 0 ;
		do {
			car1 = dBuf[x++] ;												// prise 1 ascii
			if (car1 >= '0' &&  car1 <= '9')								// conversion ascii->hexa
				val = (val*16) + (car1-'0') ;
			else if (car1 >= 'a' &&  car1 <= 'f')
				val = (val*16) + (car1-'a' + 0xa) ;
			else if (car1 >= 'A' &&  car1 <= 'F')
				val = (val*16) + (car1-'A' + 0xa) ;
			else
				pasHexa = YES ;												// pas hexa,
		} while ((pasHexa == NO) && (x<ttl)) ;
	
		uitPtr[y++] = val ;													// sauve la valeur
	 } ;
	
	[dataLus setLength:y*sizeof(UInt16)] ;
	if (append == 0)
		[paquets appendData:dataLus] ;									
	else
		[paquets setData:dataLus] ;
	  
	if ([o_wconsole isVisible])
		[self afficher] ;
}

- (IBAction)a_choix:(id)sender
{
int litem;

	litem = (int)[o_choix indexOfSelectedItem] ;
	choix_fichier.allowedFileTypes = litem == 0 ? @[@"brt"] : @[@"txt"] ;
}

// --------------------------------------------------------------------- Méthodes locales.
// recherches:  CFMutableArray  NSArray  NSThread  NSTimer NSRunLoop endian  NSAttributedString  NSMutableAttributedString
//

- (void)consoleInit
{
NSString *defoPath ;

	defoPath = [NSHomeDirectory() stringByAppendingPathComponent:@"desktop/machin.brt"] ;
	tableCode = [NSMutableArray arrayWithCapacity:4100] ;  [tableCode retain] ;
	uneCarte = sizeCarte * sizeof(UInt16) ;													// en nbr d'octets 80*2 = 160 = 0xA0
	paquets = [NSMutableData dataWithCapacity:uneCarte] ; [paquets retain] ;
	cumul = nbrLect = 0 ;
	if ([paquets length] != 0) [paquets setLength:0] ;
	montrer = [NSMutableString stringWithCapacity:10] ; [montrer setString:@""] ; [montrer retain] ;
	montrex = [NSMutableString stringWithCapacity:10] ; [montrex setString:@""] ; [montrex retain] ;
	chemin = [NSMutableString stringWithCapacity:10] ; [chemin setString:defoPath] ; [chemin retain] ;
	mechin = [NSMutableString stringWithCapacity:10] ; [mechin setString:defoPath] ; [mechin retain] ;
	attribs = [NSDictionary dictionaryWithObject:[NSFont fontWithName:@"Monaco" size:12] forKey:NSFontAttributeName] ; [attribs retain] ;
	[o_texte setTypingAttributes:attribs] ;
	append = 1 ;
	laCarte = [NSImage imageNamed:@"Punched1.icns"] ; [laCarte retain] ;
	crtCarte = nbrCarte = suivi = 0 ;
	badCard = [NSMutableData dataWithLength:(M600_COLUMN_COUNT * sizeof(UInt16))] ;	[badCard retain] ;	
	badPtr = (uint16_t *)[badCard mutableBytes] ;
}

- (void)consoleEfface
{
	[o_texte setString:@""] ;
	[paquets setLength:0] ;
	[self m600_copy_buffer:nil] ;								 // simul, efface comptage.
	[montrer setString:@""] ;
}

- (BOOL)tableCodage:(NSMutableString *)pathCode
{
NSMutableDictionary	*ceCode ;
NSMutableArray		*punch ;
NSString			*affichage ;
NSEnumerator		*enumere ;
id					clef ;
int					x, y, z ;

	ceCode = [NSMutableDictionary dictionaryWithCapacity:65] ;
	[ceCode setDictionary:[NSDictionary dictionaryWithContentsOfFile:pathCode]] ;
	if (ceCode == nil) return NO ;									// pas de lecture -> erreur
	if ([ceCode count] < 20) return NO ;							// moins de 20 clefs -> erreur
	affichage = [ceCode objectForKey:@"affiche"] ;
	if (affichage == nil) return NO ;								// la clef "affiche" n'existe pas -> erreur NSArray

	[o_ceCodage setStringValue:affichage] ;							// affiche le nom du code
	[ceCode removeObjectForKey:@"affiche"] ;						// enlève la clef "affiche" du dictionnaire
	
	[self fausseCarte:ceCode] ;										// fausse carte pour simulation *** a voir **** bug
	
	if ([tableCode count] != 0)  [tableCode removeAllObjects] ;
	for (x = 0 ; x < 4097 ; x++)
		[tableCode addObject:@" "] ;								// espace partout dans la table de codage

	punch = [NSMutableArray arrayWithCapacity:12] ;					// 12 perforations maximum par colonne
	enumere = [ceCode keyEnumerator] ;								// prépare l'énumération des codes
	while ( (clef = [enumere nextObject]) )
	 {	[punch removeAllObjects] ;
		[punch setArray:[clef componentsSeparatedByString:@","]] ;   // sépare les n° de perforation
		if ( (y=(int)[punch count]) > 0)
		 {	for (x=0 ; y > 0 ; y--)
			 {	z = [[punch objectAtIndex:y-1] intValue] ;
				if (z > 9) z = z-1 ;
				x += 1 << z ;
			 } ;
			[tableCode replaceObjectAtIndex:x withObject:[ceCode objectForKey:clef]] ;
		 } ;
	 } ;
	 
	if (([paquets length] > 0) && !lhexa)							// ré-afficher les données
		[self afficher] ;
		
	return YES ;
}

- (void)voirCodage
{
int i ;
BOOL encore ;

	[montrer appendFormat:@"%@\n", [o_ceCodage stringValue]] ;
	for (i=0, encore=YES ; encore==YES ; i++) 
	 {	cumul = (unsigned)[paquets length]/uneCarte ;											// nbr cartes dans le buffer
		[paquets increaseLengthBy: uneCarte] ;
		iBuf = (UInt16 *)[paquets mutableBytes] ;									// adresse du buffer.
		iBuf = &(iBuf[cumul * sizeCarte]) ; 										// adresse du buffer des données
		encore = [self m600_copy_code:iBuf laCarte:i] ;								// copie 1 carte
		[montrer appendString:[NSString stringWithString:[self encode:iBuf]]] ;		// ajoute au texte
	 } ;
	[o_texte setString:montrer] ;													// afficher
	[o_texte setTypingAttributes:attribs] ;
}

- (NSString *)encode:(UInt16 *)bufr
{
NSMutableString	*txtCarte, *stemp ;
int				m, n, p ;

	// r = sizeof(int) ;
	txtCarte = [NSMutableString stringWithCapacity:180] ;
	stemp = [NSMutableString stringWithCapacity:20] ;
	[txtCarte setString:@""] ;
	if (!lhexa)
		for (m = 0 ; m < sizeCarte ; m++ )
			[txtCarte appendString:[tableCode objectAtIndex:(bufr[m] & (4096-1))]] ;		// encodage ascii
	else
		for (p = n = m = 0 ; m < sizeCarte ; m++, n++, p++ )								// Hexa 5 lignes formatées
		 {	[stemp setString:[NSString stringWithFormat:@"%03X ", (bufr[m] & (0xFFF))]] ;
			if (n == 15) 
			 {	p = n = -1 ; [stemp appendString:@"\n"] ; }
			else if (p == 03)
			 {	p = -1 ; [stemp appendString:@" " ] ; } ;
			[txtCarte appendString:[NSString stringWithString:stemp]] ;
		 } ;
		 
	[txtCarte appendString:@"\n"] ;
	
	return txtCarte ;
}

- (void)metLhexa:(BOOL)yOOO
{	lhexa = yOOO ;
	if ([paquets length] > 0)
		[self afficher] ;
}

- (void)prendre
{
NSString *maCarte ;

	cumul = (unsigned)([paquets length]/uneCarte) ;												// nbr cartes dans le buffer
	[paquets increaseLengthBy: uneCarte] ;
	iBuf = (UInt16 *)[paquets mutableBytes] ;										// adresse du buffer.
	iBuf = &(iBuf[cumul * sizeCarte]) ; 
	[self m600_copy_buffer:iBuf] ;													// adresse du buffer des données
	maCarte = [NSString stringWithString:[self encode:iBuf]] ;
	[montrer appendString:maCarte] ;												// ajout texte
	[o_texte setString:montrer] ;													// affiche 
	[o_texte setTypingAttributes:attribs] ;
	[o_texte scrollRangeToVisible:(NSRange){[montrer length]-1,1}] ;
}

- (void)faitHexa
{
UInt16		*Kpt ;
unsigned	bcle, g ;

	iBuf = (UInt16 *)[paquets mutableBytes] ;
	if ([paquets length] < uneCarte ) return ;
	cumul = (unsigned)[paquets length]/uneCarte ;												// nbr de cartes lues sprintf
	[montrex setString:@""] ;														// vide le résultat
	for (g = 0, bcle = 4 * cumul ; g < bcle ; g++, iBuf = iBuf + 20 )
	 {	Kpt=iBuf ;
		[montrex appendFormat:@"%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x,%03x\n", 
								Kpt[0] & (0xFFF),Kpt[1] & (0xFFF),Kpt[2] & (0xFFF),Kpt[3] & (0xFFF),Kpt[4] & (0xFFF),
								Kpt[5] & (0xFFF),Kpt[6] & (0xFFF),Kpt[7] & (0xFFF),Kpt[8] & (0xFFF),Kpt[9] & (0xFFF),
								Kpt[10] & (0xFFF),Kpt[11] & (0xFFF),Kpt[12] & (0xFFF),Kpt[13] & (0xFFF),Kpt[14] & (0xFFF),
								Kpt[15] & (0xFFF),Kpt[16] & (0xFFF),Kpt[17] & (0xFFF),Kpt[18] & (0xFFF),Kpt[19] & (0xFFF) ] ;
	 } ;
}

- (void)faitTexte
{
int g ;

	iBuf = (UInt16 *)[paquets mutableBytes] ;
	if ([paquets length] < uneCarte ) return ;
	cumul = (unsigned)([paquets length]/uneCarte) ;												// nbr de cartes lues
	[montrer setString:@""] ;														// vide le résultat
	for (g=0 ; g<cumul ; g++, iBuf = iBuf + sizeCarte )
	 	[montrer appendString:[NSString stringWithString:[self encode:iBuf]]] ;		// fait nouveau résultat
}

- (void)afficher
{
	[self faitTexte] ;
	[o_texte setString:montrer] ;													// affiche 
	[o_texte setTypingAttributes:attribs] ;
}

- (NSString *)priseFichier:(NSString *)defautNom									// savepanel spécifique
{ 
NSInteger	quoi ;
NSInteger litem ;

	choix_fichier = [NSSavePanel savePanel] ;										// créé l'objet savePanel openPanel
	choix_fichier.canSelectHiddenExtension=YES ;
	choix_fichier.treatsFilePackagesAsDirectories=NO ;                              // ne pas ouvrir les bundles
	choix_fichier.canCreateDirectories = YES ;                                     // nouveau dossier possible
	[choix_fichier setTitle:localiser(@"save1")] ;							   // Nom du fichier de sortie (défaut)
	[choix_fichier setAccessoryView:o_lavue] ;
	litem = [o_choix indexOfSelectedItem] ;
	choix_fichier.allowedFileTypes = @[ litem==0 ? @"brt" : @"txt"]  ;
	choix_fichier.directoryURL = [NSURL fileURLWithPath:[defautNom stringByDeletingLastPathComponent]] ;
	
	quoi = [choix_fichier runModal] ;
	if (quoi == NSCancelButton) return (@"") ;
	return [NSString stringWithString:[[choix_fichier URL] path]] ;					// nom complet du fichier
}

- (NSString *)prise_Donnee:(NSString *)defautNom
{
NSArray		*les_fichiers ;
NSInteger	quoi ;

	choix_donnee = [NSOpenPanel openPanel] ;										// créé l'objet openPanel
	choix_donnee.canChooseFiles = YES ;												// choisir un fichier
	choix_donnee.canChooseDirectories = NO ;										// dossier non
	choix_donnee.resolvesAliases = NO ;												// ne pas resoudre les alias
	choix_donnee.allowsMultipleSelection = NO ;										// pas de sélection multiple
	choix_donnee.message = localiser(@"load1")  ;									// le titre
	choix_donnee.canCreateDirectories = NO ;										// pas de nouveau dossier
	[choix_donnee setAccessoryView:o_append] ;
	choix_donnee.allowedFileTypes = @[@"brt"]  ;
	choix_donnee.directoryURL = [NSURL fileURLWithPath:[defautNom stringByDeletingLastPathComponent]] ;

	quoi = [choix_donnee runModal] ;
	if (quoi == NSCancelButton) return (@"") ;										// annulé par l'utilisateur
	les_fichiers = [choix_donnee URLs] ;											// récupère la matrice des noms
	if ( [les_fichiers count] == 0) return (@"") ;									// matrice vide ?
	return [NSString stringWithString:[[les_fichiers objectAtIndex:0] path]] ;		// retourne le fichier
}

// -----------------------------------------------------------------------
// Copier les données dans un buffer d'entier.
//
- (void)m600_copy_buffer:(UInt16 *)iBuffr
{
int i ;

	if (iBuffr == nil)									// nil: mettre à zéro le comptage de paquet
	  {	suivi = 0 ; return ; } ;

	for (i = 0; i < M600_COLUMN_COUNT; ++i)				// copie le buffer des données
	 	iBuffr[i] = card_buffer[i] ;
}

// Copier la (les) fausse(s) carte(s) pour vérification
//
- (BOOL)m600_copy_code:(UInt16 *)iBuffr laCarte:(int)laQuelle
{
int i ;
UInt16			*buffer ;

	buffer = (UInt16 *)[badCard mutableBytes] ;
	buffer = &(buffer[laQuelle * M600_COLUMN_COUNT]) ;			// adresse de la carte dans le buffer
	for (i = 0 ; i < M600_COLUMN_COUNT; i++ )
			iBuffr[i] = buffer[i] ;								// copie
	return (laQuelle < (nbrCarte-1)) ;							// la dernière -> NO
}

// création d'une (ou plusieurs) fausse carte
//
- (void)fausseCarte:(NSMutableDictionary *)codeur				//
{
int				x, z, t ;
UInt16			y, *uintPtr ;
NSArray			*tmp ;
NSMutableArray  *punch ;

	crtCarte = nbrCarte = 0 ;
	t = (int)[codeur count] ;
	if (t < 10) return ;										// moins de 10 caractères!! erreur.
	nbrCarte = t/80 ;
	if ((t^80) != 0) nbrCarte += 1 ;
	t = nbrCarte * sizeof(uint16_t) * sizeCarte ;
	[badCard setLength:t] ;
	[badCard resetBytesInRange:(NSRange){0,t}] ;
	uintPtr = [badCard mutableBytes] ;
	
	tmp = [NSArray arrayWithArray:[codeur keysSortedByValueUsingSelector:@selector(compare:)]] ; // trier par valeur
	punch = [NSMutableArray arrayWithCapacity:12] ;
	for (x=0 ; x<[tmp count] ; x++)
	 {	y = 0 ;
		if ([[tmp objectAtIndex:x] length] != 0)
		 {  [punch setArray:[[tmp objectAtIndex:x] componentsSeparatedByString:@","]] ;
			if ( [punch count] > 0)
			 {	for (z=0 ; z<[punch count] ; z++)
				 {	t = [[punch objectAtIndex:z] intValue] ;
					if (t > 9) t = t-1 ;
					y += 1 << t ;
				 } ;
			 } ;
		 } ;
		uintPtr[x] = y ;
	 } ;
	badPtr = [badCard mutableBytes] ;
}

@end
