;--------------------------------------------------------
; File Created by SDCC : free open source ANSI-C Compiler
; Version 4.1.0 #12072 (Linux)
;--------------------------------------------------------
; PIC16 port for the Microchip 16-bit core micros
;--------------------------------------------------------
	list	p=18f4550
	radix	dec


;--------------------------------------------------------
; public variables in this module
;--------------------------------------------------------
	global	_ep0_init
	global	_ep0_in
	global	_ep0_setup
	global	_SetupBuffer
	global	_InBuffer
	global	_ep0_usb_std_request

;--------------------------------------------------------
; extern variables in this module
;--------------------------------------------------------
	extern	__gptrget1
	extern	__gptrget3
	extern	__gptrget2
	extern	_ep2_num_bytes_to_send
	extern	_ep2_source_data
	extern	_ep_bdt
	extern	_usb_device_state
	extern	_usb_active_cfg
	extern	_usb_active_alt_setting
	extern	_device_descriptor
	extern	_configuration_descriptor
	extern	_string_descriptor
	extern	_ep_init
	extern	_ep_in
	extern	_ep_out
	extern	_ep_setup
	extern	_SPPCFGbits
	extern	_SPPEPSbits
	extern	_SPPCONbits
	extern	_UFRMLbits
	extern	_UFRMHbits
	extern	_UIRbits
	extern	_UIEbits
	extern	_UEIRbits
	extern	_UEIEbits
	extern	_USTATbits
	extern	_UCONbits
	extern	_UADDRbits
	extern	_UCFGbits
	extern	_UEP0bits
	extern	_UEP1bits
	extern	_UEP2bits
	extern	_UEP3bits
	extern	_UEP4bits
	extern	_UEP5bits
	extern	_UEP6bits
	extern	_UEP7bits
	extern	_UEP8bits
	extern	_UEP9bits
	extern	_UEP10bits
	extern	_UEP11bits
	extern	_UEP12bits
	extern	_UEP13bits
	extern	_UEP14bits
	extern	_UEP15bits
	extern	_PORTAbits
	extern	_PORTBbits
	extern	_PORTCbits
	extern	_PORTDbits
	extern	_PORTEbits
	extern	_LATAbits
	extern	_LATBbits
	extern	_LATCbits
	extern	_LATDbits
	extern	_LATEbits
	extern	_DDRAbits
	extern	_TRISAbits
	extern	_DDRBbits
	extern	_TRISBbits
	extern	_DDRCbits
	extern	_TRISCbits
	extern	_DDRDbits
	extern	_TRISDbits
	extern	_DDREbits
	extern	_TRISEbits
	extern	_OSCTUNEbits
	extern	_PIE1bits
	extern	_PIR1bits
	extern	_IPR1bits
	extern	_PIE2bits
	extern	_PIR2bits
	extern	_IPR2bits
	extern	_EECON1bits
	extern	_RCSTAbits
	extern	_TXSTAbits
	extern	_T3CONbits
	extern	_CMCONbits
	extern	_CVRCONbits
	extern	_CCP1ASbits
	extern	_ECCP1ASbits
	extern	_CCP1DELbits
	extern	_ECCP1DELbits
	extern	_BAUDCONbits
	extern	_BAUDCTLbits
	extern	_CCP2CONbits
	extern	_CCP1CONbits
	extern	_ECCP1CONbits
	extern	_ADCON2bits
	extern	_ADCON1bits
	extern	_ADCON0bits
	extern	_SSPCON2bits
	extern	_SSPCON1bits
	extern	_SSPSTATbits
	extern	_T2CONbits
	extern	_T1CONbits
	extern	_RCONbits
	extern	_WDTCONbits
	extern	_HLVDCONbits
	extern	_LVDCONbits
	extern	_OSCCONbits
	extern	_T0CONbits
	extern	_STATUSbits
	extern	_INTCON3bits
	extern	_INTCON2bits
	extern	_INTCONbits
	extern	_STKPTRbits
	extern	_SPPDATA
	extern	_SPPCFG
	extern	_SPPEPS
	extern	_SPPCON
	extern	_UFRM
	extern	_UFRML
	extern	_UFRMH
	extern	_UIR
	extern	_UIE
	extern	_UEIR
	extern	_UEIE
	extern	_USTAT
	extern	_UCON
	extern	_UADDR
	extern	_UCFG
	extern	_UEP0
	extern	_UEP1
	extern	_UEP2
	extern	_UEP3
	extern	_UEP4
	extern	_UEP5
	extern	_UEP6
	extern	_UEP7
	extern	_UEP8
	extern	_UEP9
	extern	_UEP10
	extern	_UEP11
	extern	_UEP12
	extern	_UEP13
	extern	_UEP14
	extern	_UEP15
	extern	_PORTA
	extern	_PORTB
	extern	_PORTC
	extern	_PORTD
	extern	_PORTE
	extern	_LATA
	extern	_LATB
	extern	_LATC
	extern	_LATD
	extern	_LATE
	extern	_DDRA
	extern	_TRISA
	extern	_DDRB
	extern	_TRISB
	extern	_DDRC
	extern	_TRISC
	extern	_DDRD
	extern	_TRISD
	extern	_DDRE
	extern	_TRISE
	extern	_OSCTUNE
	extern	_PIE1
	extern	_PIR1
	extern	_IPR1
	extern	_PIE2
	extern	_PIR2
	extern	_IPR2
	extern	_EECON1
	extern	_EECON2
	extern	_EEDATA
	extern	_EEADR
	extern	_RCSTA
	extern	_TXSTA
	extern	_TXREG
	extern	_RCREG
	extern	_SPBRG
	extern	_SPBRGH
	extern	_T3CON
	extern	_TMR3
	extern	_TMR3L
	extern	_TMR3H
	extern	_CMCON
	extern	_CVRCON
	extern	_CCP1AS
	extern	_ECCP1AS
	extern	_CCP1DEL
	extern	_ECCP1DEL
	extern	_BAUDCON
	extern	_BAUDCTL
	extern	_CCP2CON
	extern	_CCPR2
	extern	_CCPR2L
	extern	_CCPR2H
	extern	_CCP1CON
	extern	_ECCP1CON
	extern	_CCPR1
	extern	_CCPR1L
	extern	_CCPR1H
	extern	_ADCON2
	extern	_ADCON1
	extern	_ADCON0
	extern	_ADRES
	extern	_ADRESL
	extern	_ADRESH
	extern	_SSPCON2
	extern	_SSPCON1
	extern	_SSPSTAT
	extern	_SSPADD
	extern	_SSPBUF
	extern	_T2CON
	extern	_PR2
	extern	_TMR2
	extern	_T1CON
	extern	_TMR1
	extern	_TMR1L
	extern	_TMR1H
	extern	_RCON
	extern	_WDTCON
	extern	_HLVDCON
	extern	_LVDCON
	extern	_OSCCON
	extern	_T0CON
	extern	_TMR0
	extern	_TMR0L
	extern	_TMR0H
	extern	_STATUS
	extern	_FSR2L
	extern	_FSR2H
	extern	_PLUSW2
	extern	_PREINC2
	extern	_POSTDEC2
	extern	_POSTINC2
	extern	_INDF2
	extern	_BSR
	extern	_FSR1L
	extern	_FSR1H
	extern	_PLUSW1
	extern	_PREINC1
	extern	_POSTDEC1
	extern	_POSTINC1
	extern	_INDF1
	extern	_WREG
	extern	_FSR0L
	extern	_FSR0H
	extern	_PLUSW0
	extern	_PREINC0
	extern	_POSTDEC0
	extern	_POSTINC0
	extern	_INDF0
	extern	_INTCON3
	extern	_INTCON2
	extern	_INTCON
	extern	_PROD
	extern	_PRODL
	extern	_PRODH
	extern	_TABLAT
	extern	_TBLPTR
	extern	_TBLPTRL
	extern	_TBLPTRH
	extern	_TBLPTRU
	extern	_PC
	extern	_PCL
	extern	_PCLATH
	extern	_PCLATU
	extern	_STKPTR
	extern	_TOS
	extern	_TOSL
	extern	_TOSH
	extern	_TOSU
	extern	_fill_in_buffer
	extern	_section_descriptor
	extern	_boot_device_descriptor
	extern	_boot_configuration_descriptor
	extern	_boot_string_descriptor
	extern	_str0
	extern	_str1
	extern	_str2
	extern	_str3
	extern	_boot_ep_init
	extern	_boot_ep_in
	extern	_boot_ep_out
	extern	_boot_ep_setup

;--------------------------------------------------------
;	Equates to used internal registers
;--------------------------------------------------------
STATUS	equ	0xfd8
PCL	equ	0xff9
PCLATH	equ	0xffa
PCLATU	equ	0xffb
INTCON	equ	0xff2
WREG	equ	0xfe8
TOSL	equ	0xffd
TOSH	equ	0xffe
TOSU	equ	0xfff
FSR0L	equ	0xfe9
FSR1L	equ	0xfe1
FSR2L	equ	0xfd9
INDF0	equ	0xfef
POSTINC0	equ	0xfee
POSTDEC1	equ	0xfe5
PREINC1	equ	0xfe4
PRODL	equ	0xff3
PRODH	equ	0xff4


; Internal registers
.registers	udata_ovr	0x0000
r0x00	res	1
r0x01	res	1
r0x02	res	1
r0x03	res	1
r0x04	res	1
r0x05	res	1


usb_buf	udata
_SetupBuffer	res	8
_InBuffer	res	8

udata_ep0_0	udata
_ep0_state	res	1

udata_ep0_1	udata
_num_bytes_to_be_send	res	2

udata_ep0_2	udata
_sourceData	res	3

udata_ep0_3	udata
_coming_cfg	res	1

udata_ep0_4	udata
_ret_status	res	2

udata_ep0_5	udata
_ep0_usb_std_request_unknown_request_65536_23	res	1

udata_ep0_6	udata
_ep0_in_i_196608_49	res	1

;--------------------------------------------------------
; global & static initialisations
;--------------------------------------------------------
; I code from now on!
; ; Starting pCode block
S_ep0__ep0_setup	code
_ep0_setup:
;	.line	203; ../src/ep0.c	void ep0_setup(void)
	MOVFF	FSR2L, POSTDEC1
	MOVFF	FSR1L, FSR2L
	MOVFF	r0x00, POSTDEC1
	MOVFF	r0x01, POSTDEC1
	MOVFF	r0x02, POSTDEC1
	MOVFF	r0x03, POSTDEC1
	MOVFF	r0x04, POSTDEC1
	MOVFF	r0x05, POSTDEC1
	BANKSEL	_ep0_state
;	.line	205; ../src/ep0.c	ep0_state = WAIT_SETUP;
	CLRF	_ep0_state, B
	BANKSEL	_num_bytes_to_be_send
;	.line	206; ../src/ep0.c	num_bytes_to_be_send = 0;
	CLRF	_num_bytes_to_be_send, B
	BANKSEL	(_num_bytes_to_be_send + 1)
	CLRF	(_num_bytes_to_be_send + 1), B
;	.line	208; ../src/ep0.c	if(ep0_usb_std_request())
	CALL	_ep0_usb_std_request
	MOVWF	r0x00
	MOVF	r0x00, W
	BTFSC	STATUS, 2
	BRA	_00294_DS_
;	.line	210; ../src/ep0.c	UCONbits.PKTDIS = 0;
	BCF	_UCONbits, 4
;	.line	211; ../src/ep0.c	if(SetupBuffer.data_transfer_direction == DEVICE_TO_HOST)
	CLRF	r0x00
	BANKSEL	_SetupBuffer
	BTFSC	_SetupBuffer, 7, B
	INCF	r0x00, F
	MOVF	r0x00, W
	XORLW	0x01
	BZ	_00311_DS_
	BRA	_00291_DS_
_00311_DS_:
;	.line	213; ../src/ep0.c	ep0_state = WAIT_IN;
	MOVLW	0x01
	BANKSEL	_ep0_state
	MOVWF	_ep0_state, B
;	.line	215; ../src/ep0.c	EP_OUT_BD(0).Cnt = EP0_BUFFER_SIZE;
	MOVLW	0x08
	BANKSEL	(_ep_bdt + 1)
	MOVWF	(_ep_bdt + 1), B
;	.line	216; ../src/ep0.c	EP_OUT_BD(0).ADR = (uchar __data *)&SetupBuffer;
	MOVLW	LOW(_SetupBuffer)
	MOVWF	r0x00
	MOVLW	HIGH(_SetupBuffer)
	MOVWF	r0x01
	MOVF	r0x00, W
	BANKSEL	(_ep_bdt + 2)
	MOVWF	(_ep_bdt + 2), B
	MOVF	r0x01, W
	BANKSEL	(_ep_bdt + 3)
	MOVWF	(_ep_bdt + 3), B
;	.line	217; ../src/ep0.c	EP_OUT_BD(0).Stat.uc = BDS_USIE;
	MOVLW	0x80
	BANKSEL	_ep_bdt
	MOVWF	_ep_bdt, B
;	.line	219; ../src/ep0.c	EP_IN_BD(0).ADR = (uchar __data *)InBuffer;
	MOVLW	LOW(_InBuffer)
	MOVWF	r0x00
	MOVLW	HIGH(_InBuffer)
	MOVWF	r0x01
	MOVF	r0x00, W
	BANKSEL	(_ep_bdt + 6)
	MOVWF	(_ep_bdt + 6), B
	MOVF	r0x01, W
	BANKSEL	(_ep_bdt + 7)
	MOVWF	(_ep_bdt + 7), B
;	.line	220; ../src/ep0.c	if(SetupBuffer.wLength < num_bytes_to_be_send)
	LFSR	0x00, (_SetupBuffer + 6)
	MOVFF	POSTINC0, r0x00
	MOVFF	INDF0, r0x01
	BANKSEL	(_num_bytes_to_be_send + 1)
	MOVF	(_num_bytes_to_be_send + 1), W, B
	SUBWF	r0x01, W
	BNZ	_00312_DS_
	BANKSEL	_num_bytes_to_be_send
	MOVF	_num_bytes_to_be_send, W, B
	SUBWF	r0x00, W
_00312_DS_:
	BC	_00289_DS_
;	.line	222; ../src/ep0.c	num_bytes_to_be_send = SetupBuffer.wLength;
	LFSR	0x00, (_SetupBuffer + 6)
	MOVFF	POSTINC0, _num_bytes_to_be_send
	MOVFF	INDF0, (_num_bytes_to_be_send + 1)
_00289_DS_:
;	.line	224; ../src/ep0.c	fill_in_buffer(0, &sourceData, EP0_BUFFER_SIZE, &num_bytes_to_be_send);
	MOVLW	HIGH(_sourceData)
	MOVWF	r0x01
	MOVLW	LOW(_sourceData)
	MOVWF	r0x00
	MOVLW	0x80
	MOVWF	r0x02
	MOVLW	HIGH(_num_bytes_to_be_send)
	MOVWF	r0x04
	MOVLW	LOW(_num_bytes_to_be_send)
	MOVWF	r0x03
	MOVLW	0x80
	MOVWF	r0x05
	MOVF	r0x05, W
	MOVWF	POSTDEC1
	MOVF	r0x04, W
	MOVWF	POSTDEC1
	MOVF	r0x03, W
	MOVWF	POSTDEC1
	MOVLW	0x00
	MOVWF	POSTDEC1
	MOVLW	0x08
	MOVWF	POSTDEC1
	MOVF	r0x02, W
	MOVWF	POSTDEC1
	MOVF	r0x01, W
	MOVWF	POSTDEC1
	MOVF	r0x00, W
	MOVWF	POSTDEC1
	MOVLW	0x00
	MOVWF	POSTDEC1
	CALL	_fill_in_buffer
	MOVLW	0x09
	ADDWF	FSR1L, F
;	.line	225; ../src/ep0.c	EP_IN_BD(0).Stat.uc = BDS_USIE | BDS_DAT1 | BDS_DTSEN;
	MOVLW	0xc8
	BANKSEL	(_ep_bdt + 4)
	MOVWF	(_ep_bdt + 4), B
	BRA	_00296_DS_
_00291_DS_:
;	.line	230; ../src/ep0.c	ep0_state = WAIT_OUT;
	MOVLW	0x02
	BANKSEL	_ep0_state
	MOVWF	_ep0_state, B
;	.line	232; ../src/ep0.c	EP_OUT_BD(0).Cnt = EP0_BUFFER_SIZE;
	MOVLW	0x08
	BANKSEL	(_ep_bdt + 1)
	MOVWF	(_ep_bdt + 1), B
;	.line	233; ../src/ep0.c	EP_OUT_BD(0).ADR = (uchar __data *)InBuffer;
	MOVLW	LOW(_InBuffer)
	MOVWF	r0x00
	MOVLW	HIGH(_InBuffer)
	MOVWF	r0x01
	MOVF	r0x00, W
	BANKSEL	(_ep_bdt + 2)
	MOVWF	(_ep_bdt + 2), B
	MOVF	r0x01, W
	BANKSEL	(_ep_bdt + 3)
	MOVWF	(_ep_bdt + 3), B
;	.line	234; ../src/ep0.c	EP_OUT_BD(0).Stat.uc = BDS_USIE | BDS_DAT1 | BDS_DTSEN;
	MOVLW	0xc8
	BANKSEL	_ep_bdt
	MOVWF	_ep_bdt, B
	BANKSEL	(_ep_bdt + 5)
;	.line	236; ../src/ep0.c	EP_IN_BD(0).Cnt = 0;
	CLRF	(_ep_bdt + 5), B
;	.line	237; ../src/ep0.c	EP_IN_BD(0).Stat.uc = BDS_USIE | BDS_DAT1 | BDS_DTSEN;
	MOVLW	0xc8
	BANKSEL	(_ep_bdt + 4)
	MOVWF	(_ep_bdt + 4), B
	BRA	_00296_DS_
_00294_DS_:
;	.line	242; ../src/ep0.c	UCONbits.PKTDIS = 0;
	BCF	_UCONbits, 4
;	.line	243; ../src/ep0.c	EP_OUT_BD(0).Cnt = EP0_BUFFER_SIZE;
	MOVLW	0x08
	BANKSEL	(_ep_bdt + 1)
	MOVWF	(_ep_bdt + 1), B
;	.line	244; ../src/ep0.c	EP_OUT_BD(0).ADR = (uchar __data *)&SetupBuffer;
	MOVLW	LOW(_SetupBuffer)
	MOVWF	r0x00
	MOVLW	HIGH(_SetupBuffer)
	MOVWF	r0x01
	MOVF	r0x00, W
	BANKSEL	(_ep_bdt + 2)
	MOVWF	(_ep_bdt + 2), B
	MOVF	r0x01, W
	BANKSEL	(_ep_bdt + 3)
	MOVWF	(_ep_bdt + 3), B
;	.line	245; ../src/ep0.c	EP_OUT_BD(0).Stat.uc = BDS_USIE | BDS_BSTALL;
	MOVLW	0x84
	BANKSEL	_ep_bdt
	MOVWF	_ep_bdt, B
;	.line	247; ../src/ep0.c	EP_IN_BD(0).Stat.uc  = BDS_USIE | BDS_BSTALL;
	MOVLW	0x84
	BANKSEL	(_ep_bdt + 4)
	MOVWF	(_ep_bdt + 4), B
_00296_DS_:
;	.line	249; ../src/ep0.c	}
	MOVFF	PREINC1, r0x05
	MOVFF	PREINC1, r0x04
	MOVFF	PREINC1, r0x03
	MOVFF	PREINC1, r0x02
	MOVFF	PREINC1, r0x01
	MOVFF	PREINC1, r0x00
	MOVFF	PREINC1, FSR2L
	RETURN	

; ; Starting pCode block
S_ep0__ep0_in	code
_ep0_in:
;	.line	134; ../src/ep0.c	void ep0_in(void)
	MOVFF	FSR2L, POSTDEC1
	MOVFF	FSR1L, FSR2L
	MOVFF	r0x00, POSTDEC1
	MOVFF	r0x01, POSTDEC1
	MOVFF	r0x02, POSTDEC1
	MOVFF	r0x03, POSTDEC1
	MOVFF	r0x04, POSTDEC1
	MOVFF	r0x05, POSTDEC1
;	.line	136; ../src/ep0.c	if(GET_DEVICE_STATE() == ADDRESS_PENDING_STATE)
	MOVF	_usb_device_state, W
	XORLW	0x04
	BNZ	_00226_DS_
;	.line	138; ../src/ep0.c	UADDR = SetupBuffer.bAddress;
	LFSR	0x00, (_SetupBuffer + 2)
	MOVFF	INDF0, _UADDR
;	.line	139; ../src/ep0.c	if(UADDR != 0)
	MOVF	_UADDR, W
	BZ	_00223_DS_
;	.line	141; ../src/ep0.c	SET_DEVICE_STATE(ADDRESS_STATE);
	MOVLW	0x05
	MOVWF	_usb_device_state
	BRA	_00226_DS_
_00223_DS_:
;	.line	145; ../src/ep0.c	SET_DEVICE_STATE(DEFAULT_STATE);
	MOVLW	0x03
	MOVWF	_usb_device_state
_00226_DS_:
	BANKSEL	_ep0_state
;	.line	149; ../src/ep0.c	if(ep0_state == WAIT_IN)
	MOVF	_ep0_state, W, B
	XORLW	0x01
	BNZ	_00231_DS_
;	.line	151; ../src/ep0.c	fill_in_buffer(0, &sourceData, EP0_BUFFER_SIZE, &num_bytes_to_be_send);
	MOVLW	HIGH(_sourceData)
	MOVWF	r0x01
	MOVLW	LOW(_sourceData)
	MOVWF	r0x00
	MOVLW	0x80
	MOVWF	r0x02
	MOVLW	HIGH(_num_bytes_to_be_send)
	MOVWF	r0x04
	MOVLW	LOW(_num_bytes_to_be_send)
	MOVWF	r0x03
	MOVLW	0x80
	MOVWF	r0x05
	MOVF	r0x05, W
	MOVWF	POSTDEC1
	MOVF	r0x04, W
	MOVWF	POSTDEC1
	MOVF	r0x03, W
	MOVWF	POSTDEC1
	MOVLW	0x00
	MOVWF	POSTDEC1
	MOVLW	0x08
	MOVWF	POSTDEC1
	MOVF	r0x02, W
	MOVWF	POSTDEC1
	MOVF	r0x01, W
	MOVWF	POSTDEC1
	MOVF	r0x00, W
	MOVWF	POSTDEC1
	MOVLW	0x00
	MOVWF	POSTDEC1
	CALL	_fill_in_buffer
	MOVLW	0x09
	ADDWF	FSR1L, F
	BANKSEL	(_ep_bdt + 4)
;	.line	153; ../src/ep0.c	if(EP_IN_BD(0).Stat.DTS == 0)
	BTFSC	(_ep_bdt + 4), 6, B
	BRA	_00228_DS_
;	.line	155; ../src/ep0.c	EP_IN_BD(0).Stat.uc = BDS_USIE | BDS_DAT1 | BDS_DTSEN;
	MOVLW	0xc8
	BANKSEL	(_ep_bdt + 4)
	MOVWF	(_ep_bdt + 4), B
	BRA	_00232_DS_
_00228_DS_:
;	.line	159; ../src/ep0.c	EP_IN_BD(0).Stat.uc = BDS_USIE | BDS_DAT0 | BDS_DTSEN;
	MOVLW	0x88
	BANKSEL	(_ep_bdt + 4)
	MOVWF	(_ep_bdt + 4), B
	BRA	_00232_DS_
_00231_DS_:
;	.line	164; ../src/ep0.c	ep0_init();
	CALL	_ep0_init
_00232_DS_:
;	.line	167; ../src/ep0.c	if(GET_DEVICE_STATE() == CONFIGURATION_PENDING_STATE)
	MOVF	_usb_device_state, W
	XORLW	0x06
	BZ	_00282_DS_
	BRA	_00241_DS_
_00282_DS_:
;	.line	171; ../src/ep0.c	UEP1  = 0; UEP2  = 0; UEP3  = 0; UEP4  = 0;
	CLRF	_UEP1
	CLRF	_UEP2
	CLRF	_UEP3
	CLRF	_UEP4
;	.line	172; ../src/ep0.c	UEP5  = 0; UEP6  = 0; UEP7  = 0; UEP8  = 0;
	CLRF	_UEP5
	CLRF	_UEP6
	CLRF	_UEP7
	CLRF	_UEP8
;	.line	173; ../src/ep0.c	UEP9  = 0; UEP10 = 0; UEP11 = 0; UEP12 = 0;
	CLRF	_UEP9
	CLRF	_UEP10
	CLRF	_UEP11
	CLRF	_UEP12
;	.line	174; ../src/ep0.c	UEP13 = 0; UEP14 = 0; UEP15 = 0;
	CLRF	_UEP13
	CLRF	_UEP14
	CLRF	_UEP15
;	.line	177; ../src/ep0.c	ep_init = boot_ep_init;
	MOVLW	UPPER(_boot_ep_init)
	BANKSEL	(_ep_init + 2)
	MOVWF	(_ep_init + 2), B
	MOVLW	HIGH(_boot_ep_init)
	BANKSEL	(_ep_init + 1)
	MOVWF	(_ep_init + 1), B
	MOVLW	LOW(_boot_ep_init)
	BANKSEL	_ep_init
	MOVWF	_ep_init, B
;	.line	178; ../src/ep0.c	ep_in = boot_ep_in;
	MOVLW	UPPER(_boot_ep_in)
	BANKSEL	(_ep_in + 2)
	MOVWF	(_ep_in + 2), B
	MOVLW	HIGH(_boot_ep_in)
	BANKSEL	(_ep_in + 1)
	MOVWF	(_ep_in + 1), B
	MOVLW	LOW(_boot_ep_in)
	BANKSEL	_ep_in
	MOVWF	_ep_in, B
;	.line	179; ../src/ep0.c	ep_out = boot_ep_out;
	MOVLW	UPPER(_boot_ep_out)
	BANKSEL	(_ep_out + 2)
	MOVWF	(_ep_out + 2), B
	MOVLW	HIGH(_boot_ep_out)
	BANKSEL	(_ep_out + 1)
	MOVWF	(_ep_out + 1), B
	MOVLW	LOW(_boot_ep_out)
	BANKSEL	_ep_out
	MOVWF	_ep_out, B
;	.line	180; ../src/ep0.c	ep_setup = boot_ep_setup;
	MOVLW	UPPER(_boot_ep_setup)
	BANKSEL	(_ep_setup + 2)
	MOVWF	(_ep_setup + 2), B
	MOVLW	HIGH(_boot_ep_setup)
	BANKSEL	(_ep_setup + 1)
	MOVWF	(_ep_setup + 1), B
	MOVLW	LOW(_boot_ep_setup)
	BANKSEL	_ep_setup
	MOVWF	_ep_setup, B
;	.line	182; ../src/ep0.c	SET_ACTIVE_CONFIGURATION(coming_cfg);
	MOVFF	_coming_cfg, _usb_active_cfg
	BANKSEL	_coming_cfg
;	.line	184; ../src/ep0.c	if(coming_cfg == 0)
	MOVF	_coming_cfg, W, B
	BNZ	_00235_DS_
;	.line	186; ../src/ep0.c	SET_DEVICE_STATE(ADDRESS_STATE);
	MOVLW	0x05
	MOVWF	_usb_device_state
	BRA	_00241_DS_
_00235_DS_:
;	.line	193; ../src/ep0.c	for(i = USB_MAX_ENDPOINTS - 1; i > 0; i--)
	MOVLW	0x02
	BANKSEL	_ep0_in_i_196608_49
	MOVWF	_ep0_in_i_196608_49, B
; ;multiply lit val:0x03 by variable _coming_cfg and store in r0x00
_00239_DS_:
	BANKSEL	_coming_cfg
;	.line	195; ../src/ep0.c	ep_init[coming_cfg][i]();
	MOVF	_coming_cfg, W, B
	MULLW	0x03
	MOVF	PRODH, W
	MOVWF	r0x01
	MOVFF	PRODL, r0x00
	CLRF	r0x02
	BANKSEL	_ep_init
	MOVF	_ep_init, W, B
	ADDWF	r0x00, F
	BANKSEL	(_ep_init + 1)
	MOVF	(_ep_init + 1), W, B
	ADDWFC	r0x01, F
	BANKSEL	(_ep_init + 2)
	MOVF	(_ep_init + 2), W, B
	ADDWFC	r0x02, F
	MOVFF	r0x00, FSR0L
	MOVFF	r0x01, PRODL
	MOVF	r0x02, W
	CALL	__gptrget3
	MOVWF	r0x00
	MOVFF	PRODL, r0x01
	MOVFF	PRODH, r0x02
; ;multiply lit val:0x03 by variable _ep0_in_i_196608_49 and store in r0x03
	BANKSEL	_ep0_in_i_196608_49
	MOVF	_ep0_in_i_196608_49, W, B
	MULLW	0x03
	MOVF	PRODH, W
	MOVWF	r0x04
	MOVFF	PRODL, r0x03
	MOVF	r0x03, W
	ADDWF	r0x00, F
	MOVF	r0x04, W
	ADDWFC	r0x01, F
	CLRF	WREG
	ADDWFC	r0x02, F
	MOVFF	r0x00, FSR0L
	MOVFF	r0x01, PRODL
	MOVF	r0x02, W
	CALL	__gptrget3
	MOVWF	r0x00
	MOVFF	PRODL, r0x01
	MOVFF	PRODH, r0x02
	MOVFF	INTCON, POSTDEC1
	BCF	INTCON, 7
	PUSH	
	MOVLW	LOW(_00283_DS_)
	MOVWF	TOSL
	MOVLW	HIGH(_00283_DS_)
	MOVWF	TOSH
	MOVLW	UPPER(_00283_DS_)
	MOVWF	TOSU
	BTFSC	PREINC1, 7
	BSF	INTCON, 7
	MOVFF	r0x02, PCLATU
	MOVFF	r0x01, PCLATH
	MOVF	r0x00, W
	MOVWF	PCL
_00283_DS_:
	BANKSEL	_ep0_in_i_196608_49
;	.line	193; ../src/ep0.c	for(i = USB_MAX_ENDPOINTS - 1; i > 0; i--)
	DECF	_ep0_in_i_196608_49, F, B
	BANKSEL	_ep0_in_i_196608_49
	MOVF	_ep0_in_i_196608_49, W, B
	BTFSS	STATUS, 2
	BRA	_00239_DS_
;	.line	198; ../src/ep0.c	SET_DEVICE_STATE(CONFIGURED_STATE);
	MOVLW	0x07
	MOVWF	_usb_device_state
_00241_DS_:
;	.line	201; ../src/ep0.c	}
	MOVFF	PREINC1, r0x05
	MOVFF	PREINC1, r0x04
	MOVFF	PREINC1, r0x03
	MOVFF	PREINC1, r0x02
	MOVFF	PREINC1, r0x01
	MOVFF	PREINC1, r0x00
	MOVFF	PREINC1, FSR2L
	RETURN	

; ; Starting pCode block
S_ep0__ep0_init	code
_ep0_init:
;	.line	124; ../src/ep0.c	void ep0_init(void)
	MOVFF	FSR2L, POSTDEC1
	MOVFF	FSR1L, FSR2L
	MOVFF	r0x00, POSTDEC1
	MOVFF	r0x01, POSTDEC1
	BANKSEL	_ep0_state
;	.line	126; ../src/ep0.c	ep0_state = WAIT_SETUP;
	CLRF	_ep0_state, B
;	.line	127; ../src/ep0.c	EP_OUT_BD(0).Cnt = EP0_BUFFER_SIZE;
	MOVLW	0x08
	BANKSEL	(_ep_bdt + 1)
	MOVWF	(_ep_bdt + 1), B
;	.line	128; ../src/ep0.c	EP_OUT_BD(0).ADR = (uchar __data *)&SetupBuffer;
	MOVLW	LOW(_SetupBuffer)
	MOVWF	r0x00
	MOVLW	HIGH(_SetupBuffer)
	MOVWF	r0x01
	MOVF	r0x00, W
	BANKSEL	(_ep_bdt + 2)
	MOVWF	(_ep_bdt + 2), B
	MOVF	r0x01, W
	BANKSEL	(_ep_bdt + 3)
	MOVWF	(_ep_bdt + 3), B
;	.line	129; ../src/ep0.c	EP_OUT_BD(0).Stat.uc = BDS_USIE | BDS_DAT0 | BDS_DTSEN;
	MOVLW	0x88
	BANKSEL	_ep_bdt
	MOVWF	_ep_bdt, B
	BANKSEL	(_ep_bdt + 4)
;	.line	130; ../src/ep0.c	EP_IN_BD(0).Stat.uc = BDS_UCPU;
	CLRF	(_ep_bdt + 4), B
;	.line	131; ../src/ep0.c	UEP0 = EPINEN_EN | EPOUTEN_EN | EPHSHK_EN;
	MOVLW	0x16
	MOVWF	_UEP0
;	.line	132; ../src/ep0.c	}
	MOVFF	PREINC1, r0x01
	MOVFF	PREINC1, r0x00
	MOVFF	PREINC1, FSR2L
	RETURN	

; ; Starting pCode block
S_ep0__ep0_usb_std_request	code
_ep0_usb_std_request:
;	.line	32; ../src/ep0.c	uchar ep0_usb_std_request(void)
	MOVFF	FSR2L, POSTDEC1
	MOVFF	FSR1L, FSR2L
	MOVFF	r0x00, POSTDEC1
	MOVFF	r0x01, POSTDEC1
	MOVFF	r0x02, POSTDEC1
	BANKSEL	_ep0_usb_std_request_unknown_request_65536_23
;	.line	37; ../src/ep0.c	unknown_request = FALSE;
	CLRF	_ep0_usb_std_request_unknown_request_65536_23, B
	BANKSEL	_SetupBuffer
;	.line	39; ../src/ep0.c	if(SetupBuffer.request_type != STANDARD)
	MOVF	_SetupBuffer, W, B
	SWAPF	WREG, W
	RRNCF	WREG, W
	ANDLW	0x03
	MOVWF	r0x00
	MOVF	r0x00, W
	BZ	_00106_DS_
;	.line	41; ../src/ep0.c	return FALSE;
	CLRF	WREG
	BRA	_00131_DS_
_00106_DS_:
;	.line	44; ../src/ep0.c	switch(SetupBuffer.bRequest)
	LFSR	0x00, (_SetupBuffer + 1)
	MOVFF	INDF0, r0x00
	MOVF	r0x00, W
	BNZ	_00190_DS_
	BRA	_00116_DS_
_00190_DS_:
	MOVF	r0x00, W
	XORLW	0x01
	BNZ	_00192_DS_
	BRA	_00130_DS_
_00192_DS_:
	MOVF	r0x00, W
	XORLW	0x03
	BNZ	_00194_DS_
	BRA	_00130_DS_
_00194_DS_:
	MOVF	r0x00, W
	XORLW	0x05
	BNZ	_00196_DS_
	BRA	_00122_DS_
_00196_DS_:
	MOVF	r0x00, W
	XORLW	0x06
	BZ	_00109_DS_
	MOVF	r0x00, W
	XORLW	0x08
	BZ	_00108_DS_
	MOVF	r0x00, W
	XORLW	0x09
	BNZ	_00202_DS_
	BRA	_00123_DS_
_00202_DS_:
	MOVF	r0x00, W
	XORLW	0x0a
	BNZ	_00204_DS_
	BRA	_00130_DS_
_00204_DS_:
	MOVF	r0x00, W
	XORLW	0x0b
	BNZ	_00206_DS_
	BRA	_00130_DS_
_00206_DS_:
	BRA	_00129_DS_
_00108_DS_:
;	.line	50; ../src/ep0.c	sourceData = &GET_ACTIVE_CONFIGURATION();
	MOVLW	HIGH(_usb_active_cfg)
	BANKSEL	(_sourceData + 1)
	MOVWF	(_sourceData + 1), B
	MOVLW	LOW(_usb_active_cfg)
	BANKSEL	_sourceData
	MOVWF	_sourceData, B
	MOVLW	0x80
	BANKSEL	(_sourceData + 2)
	MOVWF	(_sourceData + 2), B
;	.line	51; ../src/ep0.c	num_bytes_to_be_send = 1;
	MOVLW	0x01
	BANKSEL	_num_bytes_to_be_send
	MOVWF	_num_bytes_to_be_send, B
	BANKSEL	(_num_bytes_to_be_send + 1)
	CLRF	(_num_bytes_to_be_send + 1), B
;	.line	52; ../src/ep0.c	break;
	BRA	_00130_DS_
_00109_DS_:
;	.line	54; ../src/ep0.c	switch(SetupBuffer.bDescType)
	LFSR	0x00, (_SetupBuffer + 3)
	MOVFF	INDF0, r0x00
	MOVLW	0x01
	SUBWF	r0x00, W
	BTFSS	STATUS, 0
	BRA	_00113_DS_
	MOVLW	0x04
	SUBWF	r0x00, W
	BTFSC	STATUS, 0
	BRA	_00113_DS_
	DECF	r0x00, F
	CLRF	PCLATH
	CLRF	PCLATU
	RLCF	r0x00, W
	RLCF	PCLATH, F
	RLCF	WREG, W
	RLCF	PCLATH, F
	ANDLW	0xfc
	ADDLW	LOW(_00209_DS_)
	MOVWF	POSTDEC1
	MOVLW	HIGH(_00209_DS_)
	ADDWFC	PCLATH, F
	MOVLW	UPPER(_00209_DS_)
	ADDWFC	PCLATU, F
	MOVF	PREINC1, W
	MOVWF	PCL
_00209_DS_:
	GOTO	_00110_DS_
	GOTO	_00111_DS_
	GOTO	_00112_DS_
_00110_DS_:
	BANKSEL	(_device_descriptor + 2)
;	.line	57; ../src/ep0.c	sourceData = (uchar *) device_descriptor;
	MOVF	(_device_descriptor + 2), W, B
	BANKSEL	(_sourceData + 2)
	MOVWF	(_sourceData + 2), B
	BANKSEL	(_device_descriptor + 1)
	MOVF	(_device_descriptor + 1), W, B
	BANKSEL	(_sourceData + 1)
	MOVWF	(_sourceData + 1), B
	BANKSEL	_device_descriptor
	MOVF	_device_descriptor, W, B
	BANKSEL	_sourceData
	MOVWF	_sourceData, B
;	.line	58; ../src/ep0.c	num_bytes_to_be_send = device_descriptor->bLength;
	MOVFF	_device_descriptor, r0x00
	MOVFF	(_device_descriptor + 1), r0x01
	MOVFF	(_device_descriptor + 2), r0x02
	MOVFF	r0x00, FSR0L
	MOVFF	r0x01, PRODL
	MOVF	r0x02, W
	CALL	__gptrget1
	MOVWF	r0x00
	MOVFF	r0x00, _num_bytes_to_be_send
	BANKSEL	(_num_bytes_to_be_send + 1)
	CLRF	(_num_bytes_to_be_send + 1), B
;	.line	59; ../src/ep0.c	break;
	BRA	_00130_DS_
_00111_DS_:
;	.line	61; ../src/ep0.c	sourceData = configuration_descriptor[SetupBuffer.bDescIndex];
	LFSR	0x00, (_SetupBuffer + 2)
	MOVFF	INDF0, r0x00
; ;multiply lit val:0x03 by variable r0x00 and store in r0x00
	MOVF	r0x00, W
	MULLW	0x03
	MOVF	PRODH, W
	MOVWF	r0x01
	MOVFF	PRODL, r0x00
	CLRF	r0x02
	BANKSEL	_configuration_descriptor
	MOVF	_configuration_descriptor, W, B
	ADDWF	r0x00, F
	BANKSEL	(_configuration_descriptor + 1)
	MOVF	(_configuration_descriptor + 1), W, B
	ADDWFC	r0x01, F
	BANKSEL	(_configuration_descriptor + 2)
	MOVF	(_configuration_descriptor + 2), W, B
	ADDWFC	r0x02, F
	MOVFF	r0x00, FSR0L
	MOVFF	r0x01, PRODL
	MOVF	r0x02, W
	CALL	__gptrget3
	BANKSEL	_sourceData
	MOVWF	_sourceData, B
	MOVFF	PRODL, (_sourceData + 1)
	MOVFF	PRODH, (_sourceData + 2)
	BANKSEL	(_sourceData + 2)
;	.line	62; ../src/ep0.c	num_bytes_to_be_send = ((USB_Configuration_Descriptor*)sourceData)->wTotalLength;
	MOVF	(_sourceData + 2), W, B
	MOVWF	r0x02
	BANKSEL	(_sourceData + 1)
	MOVF	(_sourceData + 1), W, B
	MOVWF	r0x01
	BANKSEL	_sourceData
	MOVF	_sourceData, W, B
	MOVWF	r0x00
	MOVLW	0x02
	ADDWF	r0x00, F
	MOVLW	0x00
	ADDWFC	r0x01, F
	ADDWFC	r0x02, F
	MOVFF	r0x00, FSR0L
	MOVFF	r0x01, PRODL
	MOVF	r0x02, W
	CALL	__gptrget2
	BANKSEL	_num_bytes_to_be_send
	MOVWF	_num_bytes_to_be_send, B
	MOVFF	PRODL, (_num_bytes_to_be_send + 1)
;	.line	63; ../src/ep0.c	break;
	BRA	_00130_DS_
_00112_DS_:
;	.line	65; ../src/ep0.c	sourceData = string_descriptor[SetupBuffer.bDescIndex];
	LFSR	0x00, (_SetupBuffer + 2)
	MOVFF	INDF0, r0x00
; ;multiply lit val:0x03 by variable r0x00 and store in r0x00
	MOVF	r0x00, W
	MULLW	0x03
	MOVF	PRODH, W
	MOVWF	r0x01
	MOVFF	PRODL, r0x00
	CLRF	r0x02
	BANKSEL	_string_descriptor
	MOVF	_string_descriptor, W, B
	ADDWF	r0x00, F
	BANKSEL	(_string_descriptor + 1)
	MOVF	(_string_descriptor + 1), W, B
	ADDWFC	r0x01, F
	BANKSEL	(_string_descriptor + 2)
	MOVF	(_string_descriptor + 2), W, B
	ADDWFC	r0x02, F
	MOVFF	r0x00, FSR0L
	MOVFF	r0x01, PRODL
	MOVF	r0x02, W
	CALL	__gptrget3
	BANKSEL	_sourceData
	MOVWF	_sourceData, B
	MOVFF	PRODL, (_sourceData + 1)
	MOVFF	PRODH, (_sourceData + 2)
;	.line	66; ../src/ep0.c	num_bytes_to_be_send = sourceData[0];
	MOVFF	_sourceData, r0x00
	MOVFF	(_sourceData + 1), r0x01
	MOVFF	(_sourceData + 2), r0x02
	MOVFF	r0x00, FSR0L
	MOVFF	r0x01, PRODL
	MOVF	r0x02, W
	CALL	__gptrget1
	MOVWF	r0x00
	MOVFF	r0x00, _num_bytes_to_be_send
	BANKSEL	(_num_bytes_to_be_send + 1)
	CLRF	(_num_bytes_to_be_send + 1), B
;	.line	67; ../src/ep0.c	break;
	BRA	_00130_DS_
_00113_DS_:
;	.line	70; ../src/ep0.c	unknown_request = TRUE;
	MOVLW	0x01
	BANKSEL	_ep0_usb_std_request_unknown_request_65536_23
	MOVWF	_ep0_usb_std_request_unknown_request_65536_23, B
;	.line	73; ../src/ep0.c	break;
	BRA	_00130_DS_
_00116_DS_:
	BANKSEL	_ret_status
;	.line	79; ../src/ep0.c	ret_status = 0;
	CLRF	_ret_status, B
	BANKSEL	(_ret_status + 1)
	CLRF	(_ret_status + 1), B
	BANKSEL	_SetupBuffer
;	.line	80; ../src/ep0.c	switch(SetupBuffer.recipient)
	MOVF	_SetupBuffer, W, B
	ANDLW	0x1f
	MOVWF	r0x00
	MOVLW	0x03
	SUBWF	r0x00, W
	BTFSC	STATUS, 0
	BRA	_00130_DS_
	CLRF	PCLATH
	CLRF	PCLATU
	RLCF	r0x00, W
	RLCF	PCLATH, F
	RLCF	WREG, W
	RLCF	PCLATH, F
	ANDLW	0xfc
	ADDLW	LOW(_00211_DS_)
	MOVWF	POSTDEC1
	MOVLW	HIGH(_00211_DS_)
	ADDWFC	PCLATH, F
	MOVLW	UPPER(_00211_DS_)
	ADDWFC	PCLATU, F
	MOVF	PREINC1, W
	MOVWF	PCL
_00211_DS_:
	GOTO	_00119_DS_
	GOTO	_00119_DS_
	GOTO	_00119_DS_
_00119_DS_:
;	.line	85; ../src/ep0.c	sourceData = (uchar *) &ret_status;
	MOVLW	HIGH(_ret_status)
	BANKSEL	(_sourceData + 1)
	MOVWF	(_sourceData + 1), B
	MOVLW	LOW(_ret_status)
	BANKSEL	_sourceData
	MOVWF	_sourceData, B
	MOVLW	0x80
	BANKSEL	(_sourceData + 2)
	MOVWF	(_sourceData + 2), B
;	.line	86; ../src/ep0.c	num_bytes_to_be_send = sizeof(ret_status);
	MOVLW	0x02
	BANKSEL	_num_bytes_to_be_send
	MOVWF	_num_bytes_to_be_send, B
	BANKSEL	(_num_bytes_to_be_send + 1)
	CLRF	(_num_bytes_to_be_send + 1), B
;	.line	87; ../src/ep0.c	break;
	BRA	_00130_DS_
_00122_DS_:
;	.line	93; ../src/ep0.c	SET_DEVICE_STATE(ADDRESS_PENDING_STATE);
	MOVLW	0x04
	MOVWF	_usb_device_state
;	.line	94; ../src/ep0.c	break;
	BRA	_00130_DS_
_00123_DS_:
;	.line	97; ../src/ep0.c	if(device_descriptor->bNumConfigurations >= SetupBuffer.bConfigurationValue)
	MOVFF	_device_descriptor, r0x00
	MOVFF	(_device_descriptor + 1), r0x01
	MOVFF	(_device_descriptor + 2), r0x02
	MOVLW	0x11
	ADDWF	r0x00, F
	MOVLW	0x00
	ADDWFC	r0x01, F
	ADDWFC	r0x02, F
	MOVFF	r0x00, FSR0L
	MOVFF	r0x01, PRODL
	MOVF	r0x02, W
	CALL	__gptrget1
	MOVWF	r0x00
	LFSR	0x00, (_SetupBuffer + 2)
	MOVFF	INDF0, r0x01
	MOVF	r0x01, W
	SUBWF	r0x00, W
	BNC	_00125_DS_
;	.line	99; ../src/ep0.c	coming_cfg = SetupBuffer.bConfigurationValue;
	LFSR	0x00, (_SetupBuffer + 2)
	MOVFF	INDF0, _coming_cfg
;	.line	100; ../src/ep0.c	SET_DEVICE_STATE(CONFIGURATION_PENDING_STATE);
	MOVLW	0x06
	MOVWF	_usb_device_state
	BRA	_00130_DS_
_00125_DS_:
;	.line	104; ../src/ep0.c	unknown_request = TRUE;
	MOVLW	0x01
	BANKSEL	_ep0_usb_std_request_unknown_request_65536_23
	MOVWF	_ep0_usb_std_request_unknown_request_65536_23, B
;	.line	106; ../src/ep0.c	break;
	BRA	_00130_DS_
_00129_DS_:
;	.line	117; ../src/ep0.c	unknown_request = TRUE;
	MOVLW	0x01
	BANKSEL	_ep0_usb_std_request_unknown_request_65536_23
	MOVWF	_ep0_usb_std_request_unknown_request_65536_23, B
_00130_DS_:
	BANKSEL	_ep0_usb_std_request_unknown_request_65536_23
;	.line	120; ../src/ep0.c	return !unknown_request;
	MOVF	_ep0_usb_std_request_unknown_request_65536_23, W, B
	BSF	STATUS, 0
	TSTFSZ	WREG
	BCF	STATUS, 0
	CLRF	r0x00
	RLCF	r0x00, F
	MOVF	r0x00, W
_00131_DS_:
;	.line	121; ../src/ep0.c	}
	MOVFF	PREINC1, r0x02
	MOVFF	PREINC1, r0x01
	MOVFF	PREINC1, r0x00
	MOVFF	PREINC1, FSR2L
	RETURN	



; Statistics:
; code size:	 1652 (0x0674) bytes ( 1.26%)
;           	  826 (0x033a) words
; udata size:	   27 (0x001b) bytes ( 1.51%)
; access size:	    6 (0x0006) bytes


	end
